<?php
/* public/views/home.php
   NOTE: index.php already loads /core/helpers.php, /core/db.php, /core/seo.php
*/
require __DIR__ . '/../partials/header.php';

/* ---------- Tiny helpers just for the view (guarded) ---------- */
if (!function_exists('postsByCatSlug')) {
  function postsByCatSlug(string $slug, int $limit = 6) {
    $sql = "SELECT p.* FROM posts p
            JOIN categories c ON c.id = p.category_id
            WHERE c.slug = ? AND p.status='published'
            ORDER BY p.id DESC
            LIMIT ?";
    return DB::run($sql, [$slug, $limit])->fetchAll();
  }
}
if (!function_exists('latestPosts')) {
  function latestPosts(int $limit = 6){
    // LIMIT এ বাউন্ড প্যারাম পাঠানো যায় MySQL/MariaDB-তে – এখানে ইন্টে কাস্ট করছি
    $limit = (int)$limit;
    return DB::run("SELECT * FROM posts WHERE status='published' ORDER BY id DESC LIMIT {$limit}")
             ->fetchAll();
  }
}
if (!function_exists('img_fallback')) {
  function img_fallback(array $row, string $fallback){
    return empty($row['thumb']) ? $fallback : $row['thumb'];
  }
}
?>

<!-- ===== Top strip ===== -->
<div class="topstrip">
  <div class="wrap">
    <div><?= e(date('l, j F Y')) ?> • ঢাকা</div>
    <div style="display:flex;gap:12px">
      <a href="#">বিজ্ঞাপন</a>
      <a href="#">যোগাযোগ</a>
      <a href="#">বাংলা</a>
    </div>
  </div>
</div>

<!-- ===== Header area (brand + headlines rail + primary nav) ===== -->
<header class="site">
  <div class="wrap toprow">
    <a class="hbrand" href="<?= e(base_url('/')) ?>">
      <div class="name">ভুরের কাগজ</div>
      <div class="tag">দৈনিক অনলাইন পোর্টাল</div>
    </a>

    <div class="headrail">
      <?php foreach (latestPosts(4) as $h): ?>
      <a class="hitem" href="#">
        <img loading="lazy"
             src="<?= e(img_fallback($h, 'https://picsum.photos/100/100?random=' . ($h['id'] % 50 + 1))) ?>"
             alt="<?= e($h['title_bn']) ?>">
        <h5><?= e($h['title_bn']) ?></h5>
      </a>
      <?php endforeach; ?>
    </div>
  </div>

  <nav class="primary">
    <div class="wrap">
      <ul class="menu">
        <li><a href="#">সর্বশেষ</a></li>
        <li><a href="#">জাতীয়</a></li>
        <li><a href="#">রাজনীতি</a></li>
        <li><a href="#">সারাবাংলা</a></li>
        <li><a href="#">আন্তর্জাতিক</a></li>
        <li><a href="#">খেলা</a></li>
        <li><a href="#">বিনোদন</a></li>
      </ul>
      <div class="nav-ctl">
        <button class="navbtn" id="openSearch" type="button"><span class="ico">🔎</span><span class="label">খুঁজুন</span></button>
        <a class="navbtn" href="#"><span class="ico">📰</span><span class="label">ই-পেপার</span></a>
        <a class="navbtn" href="#"><span class="ico">🌐</span><span class="label">Eng</span></a>
        <button class="navbtn" type="button" aria-label="Menu"><span class="ico">☰</span></button>
      </div>
    </div>
  </nav>
</header>

<!-- ===== Ad strip ===== -->
<section class="ad-strip">
  <div class="ad-wrap">
    <a class="ad-banner" href="#" aria-label="বিজ্ঞাপন">
      <div class="ad-left">
        <div class="ad-brand">Bikroy-এ</div>
        <div class="ad-claim"><span>গাড়ি বিক্রির</span> <strong>স্বাধীনতা!</strong></div>
      </div>
      <div class="ad-visual">
        <img class="car" loading="lazy"
             src="https://images.unsplash.com/photo-1525609004556-c46c7d6cf023?w=640&auto=format&fit=crop"
             alt="Car">
        <span class="sold">SOLD</span>
      </div>
      <div class="ad-right">
        <button class="ad-cta" type="button">ফ্রি বিজ্ঞাপন দিন!</button>
        <div class="ad-fine">*শর্ত প্রযোজ্য</div>
        <div class="ad-smile" aria-hidden="true"><span class="eyes"></span><span class="mouth"></span></div>
      </div>
    </a>
  </div>
</section>

<!-- ===== MIX news (lead + list + promos) ===== -->
<section class="mix-news">
  <div class="mx-wrap">
    <div class="mx-grid">
      <?php
        $national = postsByCatSlug('national', 8);
        $lead     = $national[0] ?? null;
      ?>
      <div class="mx-left">
        <?php if ($lead): ?>
        <article class="lead">
          <div class="lead-text">
            <h2 class="lead-title"><?= e($lead['title_bn']) ?></h2>
            <p class="lead-sum"><?= e(mb_substr(strip_tags($lead['content_bn']), 0, 140)) ?>…</p>
          </div>
          <a class="lead-img" href="#">
            <img loading="lazy"
                 src="<?= e(img_fallback($lead, 'https://picsum.photos/900/520?random=11')) ?>"
                 alt="<?= e($lead['title_bn']) ?>">
          </a>
        </article>
        <?php endif; ?>

        <div class="left-bot">
          <?php foreach (array_slice($national, 1, 2) as $m): ?>
          <a class="mini" href="#">
            <img loading="lazy"
                 src="<?= e(img_fallback($m, 'https://picsum.photos/640/360?random=' . ($m['id'] % 90 + 1))) ?>"
                 alt="<?= e($m['title_bn']) ?>">
            <h4><?= e($m['title_bn']) ?></h4>
          </a>
          <?php endforeach; ?>
        </div>
      </div>

      <div class="mx-mid">
        <?php foreach (latestPosts(6) as $L): ?>
        <a class="li" href="#">
          <img loading="lazy"
               src="<?= e(img_fallback($L, 'https://picsum.photos/140/100?random=' . ($L['id'] % 80 + 1))) ?>"
               alt="<?= e($L['title_bn']) ?>">
          <div class="txt"><h5><?= e($L['title_bn']) ?></h5></div>
        </a>
        <?php endforeach; ?>
      </div>

      <div class="mx-right">
        <a class="promo" href="#">
          <img loading="lazy"
               src="https://images.unsplash.com/photo-1603351154351-5e2d74d0403d?q=80&w=1200&auto=format&fit=crop"
               alt="Promo">
        </a>
        <a class="promo" href="#">
          <img loading="lazy"
               src="https://images.unsplash.com/photo-1516211888891-9bccecab13ca?q=80&w=1200&auto=format&fit=crop"
               alt="Promo">
        </a>
      </div>
    </div>
  </div>
</section>

<!-- ===== National grid ===== -->
<section class="national-sec">
  <div class="ns-wrap">
    <div class="ns-head"><span>জাতীয়</span></div>
    <div class="ns-grid">
      <?php foreach ($national as $n): ?>
      <a class="ns-card" href="#">
        <img loading="lazy"
             src="<?= e(img_fallback($n, 'https://picsum.photos/640/360?random=' . ($n['id'] % 70 + 1))) ?>"
             alt="<?= e($n['title_bn']) ?>">
        <h4 class="ns-title"><?= e($n['title_bn']) ?></h4>
      </a>
      <?php endforeach; ?>
    </div>
    <div class="ns-more"><a href="#">আরও ▸</a></div>
  </div>
</section>

<!-- ===== City block ===== -->
<?php $city = postsByCatSlug('city', 7); $cityLead = $city[0] ?? null; ?>
<section class="city-capital">
  <div class="wrap">
    <div class="sec-head">রাজধানী</div>
    <div class="grid-3">
      <article class="lead">
        <?php if ($cityLead): ?>
        <a class="thumb" href="#">
          <img loading="lazy"
               src="<?= e(img_fallback($cityLead, 'https://picsum.photos/900/520?random=5101')) ?>"
               alt="<?= e($cityLead['title_bn']) ?>">
        </a>
        <h3 class="title"><?= e($cityLead['title_bn']) ?></h3>
        <p class="sum"><?= e(mb_substr(strip_tags($cityLead['content_bn']), 0, 160)) ?>…</p>
        <?php endif; ?>
      </article>

      <div class="mini-grid">
        <?php foreach (array_slice($city, 1, 6) as $c): ?>
        <article class="mini">
          <a class="thumb" href="#">
            <img loading="lazy"
                 src="<?= e(img_fallback($c, 'https://picsum.photos/520/320?random=' . ($c['id'] % 100 + 1))) ?>"
                 alt="<?= e($c['title_bn']) ?>">
          </a>
          <h4 class="mini-title"><a href="#"><?= e($c['title_bn']) ?></a></h4>
        </article>
        <?php endforeach; ?>
      </div>
    </div>
    <div class="more"><a href="#">আরও ▸</a></div>
  </div>
</section>

<!-- ===== Politics block ===== -->
<?php $pol = postsByCatSlug('politics', 9); $polLead = $pol[0] ?? null; ?>
<section class="politics-block">
  <div class="wrap">
    <div class="pol-head"><h2>রাজনীতি</h2></div>
    <div class="pol-grid">
      <article class="pol-lead">
        <?php if ($polLead): ?>
        <a class="thumb" href="#">
          <img loading="lazy"
               src="<?= e(img_fallback($polLead, 'https://picsum.photos/860/520?random=2101')) ?>"
               alt="<?= e($polLead['title_bn']) ?>">
        </a>
        <h3 class="lead-title"><?= e($polLead['title_bn']) ?></h3>
        <p class="lead-sum"><?= e(mb_substr(strip_tags($polLead['content_bn']), 0, 150)) ?>…</p>
        <?php endif; ?>
      </article>

      <div class="pol-list">
        <?php foreach (array_slice($pol, 1, 6) as $x): ?>
        <a class="mini" href="#">
          <img loading="lazy"
               src="<?= e(img_fallback($x, 'https://picsum.photos/240/140?random=' . ($x['id'] % 200 + 1))) ?>"
               alt="<?= e($x['title_bn']) ?>">
          <div class="txt"><h4><?= e($x['title_bn']) ?></h4></div>
        </a>
        <?php endforeach; ?>
        <div class="more"><a href="#">আরও ▸</a></div>
      </div>

      <aside class="opinion">
        <div class="op-head"><span class="op-ico">✎</span><span>মতামত</span></div>
        <?php foreach (array_slice($pol, 7, 2) as $op): ?>
        <a class="op-item" href="#">
          <img loading="lazy"
               src="<?= e(img_fallback($op, 'https://picsum.photos/120/84?random=' . ($op['id'] % 300 + 1))) ?>"
               alt="<?= e($op['title_bn']) ?>">
          <div class="txt"><h5><?= e($op['title_bn']) ?></h5></div>
        </a>
        <?php endforeach; ?>
      </aside>
    </div>
  </div>
</section>

<?php require __DIR__ . '/../partials/footer.php'; ?>
