<?php
// public/sitemap.php
declare(strict_types=1);

require_once dirname(__DIR__).'/core/db.php';
require_once dirname(__DIR__).'/core/seo.php';

// যেকোনো accidental output যেন না আসে
if (function_exists('ob_get_level')) {
  while (ob_get_level() > 0) { ob_end_clean(); }
}

// XML header পাঠাও
header('Content-Type: application/xml; charset=utf-8');

// বেস URL (settings থেকে)
$base = rtrim(seo_tag('seo_site_url', ''), '/').'/';
if ($base === '/') { // fallback
  $base = (isset($_SERVER['REQUEST_SCHEME']) ? $_SERVER['REQUEST_SCHEME'] : 'http')
        . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost') . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/').'/';
}

$items = DB::run("
  SELECT id, COALESCE(publish_at, created_at) AS t
  FROM posts
  WHERE status='published'
  ORDER BY t DESC
  LIMIT 500
")->fetchAll();

// **খেয়াল:** XML declaration লাইনের আগে একদম কিছু থাকবে না
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
  <url>
    <loc><?= htmlspecialchars($base) ?></loc>
    <changefreq>hourly</changefreq>
    <priority>1.0</priority>
  </url>
<?php foreach ($items as $it): ?>
  <url>
    <loc><?= htmlspecialchars($base . 'index.php?post=' . $it['id']) ?></loc>
    <lastmod><?= date('c', strtotime($it['t'])) ?></lastmod>
    <changefreq>daily</changefreq>
    <priority>0.8</priority>
  </url>
<?php endforeach; ?>
</urlset>
<?php
// সাথে সাথে শেষ
exit;
