<?php
// public/partials/header.php

require_once __DIR__ . '/../../core/db.php';
require_once __DIR__ . '/../../core/helpers.php';

if (!function_exists('vk_latest')) {
  function vk_latest(int $limit = 4) {
    $sql = "SELECT id, title_bn, thumb
            FROM posts
            WHERE status='published'
            ORDER BY id DESC
            LIMIT {$limit}";
    return DB::run($sql)->fetchAll();
  }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?= e(setting('site_title') ?? 'ভুরের কাগজ'); ?></title>

  <style>
    /* --------- Base --------- */
    :root{
      --brand:#0e1a28;
      --brand-2:#152437;
      --accent:#e50914;
      --ink:#0a0a0a;
      --muted:#667;
      --wrap:1160px;
    }
    *{box-sizing:border-box}
    html,body{margin:0;padding:0;background:#fff;color:var(--ink);
      font-family:"Noto Sans Bengali",system-ui,-apple-system,"Segoe UI",Arial,sans-serif}
    a{color:inherit;text-decoration:none}
    img{max-width:100%;display:block}
    .wrap{max-width:var(--wrap);margin:0 auto;padding:0 16px}

    /* --------- Top bar (unique class) --------- */
    .topbar{background:var(--brand);color:#cfe1ff;font-size:14px}
    .topbar .wrap{display:flex;justify-content:space-between;align-items:center;height:40px}
    .topbar a{color:#e8f1ff}
    .topbar .links{display:flex;gap:16px;align-items:center}

    /* --------- Header (logo + headline rail) --------- */
    header.site{background:#fff;border-bottom:1px solid #eef2f7}
    .toprow{display:flex;align-items:center;gap:28px;padding:14px 0}
    .hbrand{display:flex;flex-direction:column;align-items:flex-start;gap:2px}
    .hbrand .name{font-size:40px;line-height:1;font-weight:800;letter-spacing:.5px}
    .hbrand .tag{font-size:12px;color:var(--muted)}
    .headrail{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:18px;flex:1}
    .hitem{display:grid;grid-template-columns:56px 1fr;gap:10px;align-items:center}
    .hitem img{width:56px;height:56px;object-fit:cover;border-radius:6px}
    .hitem h5{margin:0;font-weight:600;font-size:14px;line-height:1.35}
    .hitem h5:before{content:"▢ ";color:var(--accent);font-weight:800}

    /* --------- Primary nav --------- */
    nav.primary{border-top:1px solid #eef2f7;border-bottom:1px solid #eef2f7;background:#fafcff}
    nav.primary .wrap{display:flex;align-items:center;justify-content:space-between}
    .menu{display:flex;gap:22px;list-style:none;margin:0;padding:0}
    .menu a{display:block;padding:14px 0;font-weight:700;color:#111}
    .menu a:hover{color:var(--accent)}
    .nav-ctl{display:flex;gap:10px;align-items:center}
    .navbtn{display:flex;align-items:center;gap:8px;padding:10px 12px;border:1px solid #e6ecf2;border-radius:8px;background:#fff;cursor:pointer}
    .navbtn .ico{font-size:16px}
    .navbtn:hover{border-color:#cfd8e3}

    /* --------- Big ad strip (under header) --------- */
    .ad-strip{background:#fff;border-bottom:1px solid #eef2f7}
    .ad-wrap{max-width:var(--wrap);margin:18px auto;padding:0 16px}
    .ad-banner{display:grid;grid-template-columns:220px 1fr 220px;align-items:center;
               gap:18px;padding:16px 18px;border:1px dashed #dbe3ee;border-radius:12px;background:#f7fbff}
    .ad-left .ad-brand{font-weight:800;color:#1b588f;font-size:18px}
    .ad-left .ad-claim{font-size:22px;color:#17324d}
    .ad-visual{position:relative}
    .ad-visual .car{width:100%;border-radius:10px}
    .ad-visual .sold{position:absolute;top:10px;left:10px;background:#ff4757;color:#fff;
                     font-weight:800;padding:6px 10px;border-radius:20px}
    .ad-right{justify-self:end;text-align:right}
    .ad-cta{background:#ffbf00;border:0;padding:10px 14px;border-radius:10px;font-weight:800;cursor:pointer}
    .ad-fine{color:#6b7a90;font-size:12px;margin-top:6px}
    .ad-smile{margin-top:6px;width:40px;height:40px;border-radius:50%;background:#fff;border:2px solid #e5eef7;display:inline-grid;place-items:center;position:relative}
    .ad-smile .eyes::before,.ad-smile .eyes::after{content:"";position:absolute;top:13px;width:6px;height:6px;background:#324b66;border-radius:50%}
    .ad-smile .eyes::before{left:10px}.ad-smile .eyes::after{right:10px}
    .ad-smile .mouth{width:18px;height:8px;border:2px solid #324b66;border-top:0;border-radius:0 0 16px 16px;position:absolute;bottom:8px;left:50%;transform:translateX(-50%)}

    /* --------- Responsive --------- */
    @media (max-width:1024px){
      .headrail{grid-template-columns:repeat(3,1fr)}
      .ad-banner{grid-template-columns:1fr}
      .ad-right{justify-self:start;text-align:left}
    }
    @media (max-width:640px){
      .hbrand .name{font-size:30px}
      .headrail{grid-template-columns:1fr 1fr}
      .menu{gap:14px;overflow:auto}
      .navbtn .label{display:none}
    }
  </style>
</head>
<body>

<!-- ===== Top bar (unique, header-only) ===== -->
<div class="topbar">
  <div class="wrap">
    <div><?= date('l, j F Y') ?> • ঢাকা</div>
    <div class="links">
      <a href="#">বিজ্ঞাপন</a>
      <a href="#">যোগাযোগ</a>
      <a href="#">বাংলা</a>
    </div>
  </div>
</div>

<!-- ===== Logo + headline rail ===== -->
<header class="site">
  <div class="wrap toprow">
    <a class="hbrand" href="<?= e(setting('base_url') ?? '/'); ?>">
      <div class="name"><?= e(setting('site_title') ?? 'ভুরের কাগজ'); ?></div>
      <div class="tag"><?= e(setting('site_tagline') ?? 'দৈনিক অনলাইন পোর্টাল'); ?></div>
    </a>

    <div class="headrail">
      <?php foreach (vk_latest(4) as $h): ?>
        <a class="hitem" href="#">
          <img src="<?= e(empty($h['thumb'])
                        ? 'https://picsum.photos/100/100?random='.($h['id']%40+1)
                        : $h['thumb']) ?>" alt="">
          <h5><?= e($h['title_bn']) ?></h5>
        </a>
      <?php endforeach; ?>
    </div>
  </div>

  <!-- ===== Primary nav ===== -->
  <nav class="primary">
    <div class="wrap">
      <ul class="menu">
        <li><a href="#">সর্বশেষ</a></li>
        <li><a href="#">জাতীয়</a></li>
        <li><a href="#">রাজনীতি</a></li>
        <li><a href="#">সারাবাংলা</a></li>
        <li><a href="#">আন্তর্জাতিক</a></li>
        <li><a href="#">খেলা</a></li>
        <li><a href="#">বিনোদন</a></li>
      </ul>
      <div class="nav-ctl">
        <button class="navbtn" type="button"><span class="ico">🔎</span><span class="label">খুঁজুন</span></button>
        <a class="navbtn" href="#"><span class="ico">📰</span><span class="label">ই-পেপার</span></a>
        <a class="navbtn" href="#"><span class="ico">🌐</span><span class="label">Eng</span></a>
        <button class="navbtn" type="button" aria-label="Menu"><span class="ico">☰</span></button>
      </div>
    </div>
  </nav>
</header>

<!-- ===== Big ad (under header) ===== -->
<section class="ad-strip">
  <div class="ad-wrap">
    <a class="ad-banner" href="#" aria-label="বিজ্ঞাপন">
      <div class="ad-left">
        <div class="ad-brand">Bikroy-এ</div>
        <div class="ad-claim"><span>গাড়ি বিক্রির</span> <strong>স্বাধীনতা!</strong></div>
      </div>
      <div class="ad-visual">
        <img class="car" src="https://images.unsplash.com/photo-1525609004556-c46c7d6cf023?w=1200&auto=format&fit=crop" alt="">
        <span class="sold">SOLD</span>
      </div>
      <div class="ad-right">
        <button class="ad-cta" type="button">ফ্রি বিজ্ঞাপন দিন!</button>
        <div class="ad-fine">*শর্ত প্রযোজ্য</div>
        <div class="ad-smile"><span class="eyes"></span><span class="mouth"></span></div>
      </div>
    </a>
  </div>
</section>
