<?php
/* public/partials/footer.php
   NOTE: no <!doctype>, <html>, <head>, <body> here – this is a partial.
*/
?>
<style>
  :root{ --bg:#e9eaed; --ink:#2b2b2b; --muted:#6b6f76; --brand:#ff9e1c; --stroke:#c9cacc; --link:#1b1d1f; --wrap:1160px; }
  .footer{max-width:1200px;margin:40px auto 0;padding:42px 16px 30px;background:#fff;border-top:1px solid var(--stroke);}
  .ft-top h3{font-weight:700;font-size:24px;line-height:1.35;margin:0 0 18px}
  .ft-top .hl{display:inline-block;position:relative;padding-right:10px}
  .ft-top .hl::after{content:"";position:absolute;left:0;right:0;bottom:-6px;height:4px;background:var(--brand)}
  .ft-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:24px}
  .ft-grid ul{list-style:none;margin:0;padding:0}
  .ft-grid li{font-size:15px;line-height:1.9}
  .ft-grid a{color:var(--link);text-decoration:none}
  .ft-grid a:hover{text-decoration:underline}
  .rule{border-top:1px solid var(--stroke);margin:24px 0}
  .ft-mid{display:grid;grid-template-columns:1.1fr 1px 1.4fr;gap:28px;align-items:start}
  .ft-col-left{color:var(--muted);font-size:14px;line-height:2;text-transform:uppercase}
  .vline{background:var(--stroke);width:1px;height:100%}
  .ft-col-right{font-size:15px;line-height:1.9}
  .ft-col-right b{font-weight:700}
  .ft-bottom{display:grid;grid-template-columns:1fr;justify-items:center;text-align:center;gap:16px;margin-top:18px}
  .badges{display:flex;gap:12px;align-items:center}
  .badge{height:42px;border-radius:8px;background:#fff;padding:0 10px;display:flex;align-items:center;border:1px solid var(--stroke);font-size:14px}
  .social{display:flex;gap:10px}
  .social a{width:34px;height:34px;border-radius:50%;background:#fff;display:flex;align-items:center;justify-content:center;border:1px solid var(--stroke)}
  .logo{height:44px}
  .copyright{font-size:13px;color:var(--muted)}
  @media (max-width:980px){
    .ft-grid{grid-template-columns:repeat(2,1fr)}
    .ft-mid{grid-template-columns:1fr;gap:16px}
    .vline{display:none}
    .ft-col-left{text-align:center}
  }
</style>

<footer class="footer" role="contentinfo">
  <div class="ft-top">
    <h3>অনুসন্ধানের জন্য প্রবেশ করুন <span class="hl">ভোরের আকাশ</span>-এ</h3>
    <div class="ft-grid">
      <ul><li><a href="#">বিশেষ আয়োজন</a></li><li><a href="#">ফিচার</a></li></ul>
      <ul><li><a href="#">কালের খেয়া</a></li><li><a href="#">আর্কাইভ</a></li></ul>
      <ul><li><a href="#">ফেসবুক লাইভ</a></li><li><a href="#">ছবি</a></li></ul>
      <ul><li><a href="#">বিজ্ঞাপন মূল্য তালিকা</a></li><li><a href="#">ভিডিও</a></li></ul>
      <ul><li><a href="#">ইউনিকোড কনভার্টার</a></li><li><a href="#">ই-পেপার</a></li></ul>
    </div>
  </div>

  <div class="rule"></div>

  <div class="ft-mid">
    <div class="ft-col-left">
      <div>Privacy Policy</div>
      <div>Terms of Use</div>
      <div>Vorer Akash – All rights reserved</div>
    </div>
    <div class="vline"></div>
    <div class="ft-col-right">
      <div><b>সম্পাদক:</b> ইলিয়াস খান</div>
      <div><b>প্রকাশক:</b> এস এম আব্দুল্লাহ নূরুজ্জামান</div>
      <div><b>ফোন:</b> +88-02-226639884 • <b>বিজ্ঞাপন:</b> +8801894961382</div>
      <div><b>ই-মেইল:</b> advt.voanewsbd@gmail.com, hr.dailyvorerakash@gmail.com</div>
      <div><b>অফিস:</b> ৩৯/২ শীতল যামান টাওয়ার (১৩ তলা), পুরানা পল্টন, ঢাকা-১০০০</div>
    </div>
  </div>

  <div class="rule"></div>

  <div class="ft-bottom">
    <div class="badges" aria-label="মোবাইল অ্যাপস ডাউনলোড করুন">
      <a href="#" class="badge">Get it on Google Play</a>
      <a href="#" class="badge">Download on the App Store</a>
    </div>

    <div>ফলো করুন <b style="color:#f4a018">ভোরের আকাশ</b>-এর খবর</div>

    <div class="social" aria-label="Social Links">
      <a href="#" title="Facebook">f</a>
      <a href="#" title="X (Twitter)">x</a>
      <a href="#" title="YouTube">▶</a>
      <a href="#" title="Instagram">◎</a>
    </div>

    <img class="logo" src="https://dummyimage.com/180x40/000/fff&text=%E0%A6%AD%E0%A7%8B%E0%A6%B0%E0%A7%87%E0%A6%B0+%E0%A6%86%E0%A6%95%E0%A6%BE%E0%A6%B6" alt="ভোরের আকাশ">

    <div class="copyright">© দৈনিক ভোরের আকাশ ২০২৪</div>
  </div>
</footer>

</body>
</html>
