<?php
require_once __DIR__.'/../core/helpers.php';
require_once __DIR__.'/../core/options.php';
require_once __DIR__.'/../core/page_renderer.php';

$home_id = (int) option_get('home_page_id', 0);

/* If a homepage is set in Options -> use it.
   Otherwise try a page with slug = `home` (published). */
echo "<!doctype html><meta charset='utf-8'>";
if ($home_id) {
  echo render_page_by_id($home_id);
} else {
  $html = render_page_by_slug('home');
  if ($html) { echo $html; }
  else { http_response_code(404); echo "<h1>404</h1>"; }
}
