-- install/install.sql
-- Create database and tables (use utf8mb4 for Bangla)
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(160) UNIQUE NOT NULL,
  role ENUM('admin','editor') NOT NULL DEFAULT 'admin',
  password VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name_bn VARCHAR(160) NOT NULL,
  slug VARCHAR(160) UNIQUE NOT NULL,
  sort_order INT NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS posts (
  id INT AUTO_INCREMENT PRIMARY KEY,
  category_id INT NULL,
  title_bn VARCHAR(300) NOT NULL,
  body_bn MEDIUMTEXT NOT NULL,
  thumbnail VARCHAR(500) NULL,
  status ENUM('draft','published','scheduled') NOT NULL DEFAULT 'draft',
  publish_at DATETIME NULL,
  meta_title VARCHAR(200) NULL,
  meta_desc VARCHAR(300) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS settings (
  name VARCHAR(120) PRIMARY KEY,
  value TEXT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- seed admin
INSERT INTO users(name,email,role,password) VALUES
('Admin','admin@example.com','admin','$2y$10$0Ck6X9Fz8hCqgdfI0e2Q1O5tYz0bF2q1QfV4Wgq9t2O3M4lZt3mI2'); -- password: admin123

-- seed categories
INSERT INTO categories(name_bn,slug,sort_order,is_active) VALUES
('সর্বশেষ','latest',1,1),('জাতীয়','national',2,1),('রাজনীতি','politics',3,1),('খেলা','sports',4,1),('বিনোদন','entertainment',5,1);

-- seed settings
INSERT INTO settings(name,value) VALUES
('site_name_bn','ভুরের কাগজ'),
('home_title','ভুরের কাগজ • হোম'),
('home_desc','বিশ্বস্ত বাংলা অনলাইন নিউজ পোর্টাল'),
('footer_about','ভুরের কাগজ—খবরের নির্ভরযোগ্য ঠিকানা।');
