<?php
// core/upload_image.php
require_once __DIR__ . '/auth.php';
require_login(); // only logged-in admins/editors can upload

header('Content-Type: application/json; charset=utf-8');

if (!isset($_FILES['file'])) {
  http_response_code(400);
  echo json_encode(['error' => 'No file uploaded']);
  exit;
}

// Validate
$f = $_FILES['file'];
if ($f['error'] !== UPLOAD_ERR_OK) {
  http_response_code(400);
  echo json_encode(['error' => 'Upload error: '.$f['error']]);
  exit;
}

$allowed = ['image/jpeg'=>'jpg','image/png'=>'png','image/gif'=>'gif','image/webp'=>'webp'];
$mime = mime_content_type($f['tmp_name']);
if (!isset($allowed[$mime])) {
  http_response_code(415);
  echo json_encode(['error' => 'Only JPG/PNG/GIF/WEBP allowed']);
  exit;
}

$ext  = $allowed[$mime];
$dir  = __DIR__ . '/../uploads/posts';
if (!is_dir($dir)) { @mkdir($dir, 0777, true); }

$fname = 'p_'.date('Ymd_His').'_' . bin2hex(random_bytes(4)) . '.' . $ext;
$dest  = $dir . '/' . $fname;

if (!move_uploaded_file($f['tmp_name'], $dest)) {
  http_response_code(500);
  echo json_encode(['error' => 'Failed to save file']);
  exit;
}

// Public URL (adjust if your base path differs)
$publicUrl = '/vurrer_kagoj_starter/vurrer_kagoj/uploads/posts/' . $fname;

// TinyMCE expects { location: "url" }
echo json_encode(['location' => $publicUrl]);
