<?php
require_once __DIR__.'/helpers.php';
require_once __DIR__.'/db.php';

/**
 * Read one setting by `name` with static cache.
 */
function setting($name, $default='') {
  static $cache = null;
  if ($cache === null) {
    $rows = DB::run("SELECT `name`,`value` FROM settings")->fetchAll();
    $cache = [];
    foreach ($rows as $r) $cache[$r['name']] = $r['value'];
  }
  return $cache[$name] ?? $default;
}

/** Aliases */
function seo_tag($name,$default=''){ return setting($name,$default); }

/** Absolute site url (from settings.seo_site_url) */
function site_url($path=''){
  $root = rtrim(seo_tag('seo_site_url',''),'/').'/';
  if ($root === '/') { $root = rtrim(base_url(''),'/').'/'; } // fallback
  return $root . ltrim($path,'/');
}

/** Article schema (JSON-LD) */
function render_article_jsonld(array $post){
  $img = !empty($post['thumbnail']) ? [$post['thumbnail']] : [];
  $url = site_url('index.php?post='.$post['id']);
  $data = [
    '@context'=>'https://schema.org',
    '@type'=>'NewsArticle',
    'headline'=>$post['title_bn'] ?? '',
    'datePublished'=>$post['publish_at'] ?? $post['created_at'] ?? '',
    'dateModified'=>$post['updated_at'] ?? ($post['publish_at'] ?? $post['created_at'] ?? ''),
    'image'=>$img,
    'author'=>['@type'=>'Person','name'=>$post['author_name'] ?? 'Staff'],
    'publisher'=>[
      '@type'=>'Organization',
      'name'=>seo_tag('site_name_bn','ভোরের আকাশ'),
      'logo'=>['@type'=>'ImageObject','url'=>seo_tag('site_logo','')]
    ],
    'mainEntityOfPage'=>['@type'=>'WebPage','@id'=>$url],
    'url'=>$url
  ];
  return '<script type="application/ld+json">'.json_encode($data,JSON_UNESCAPED_UNICODE).'</script>';
}
