<?php
require_once __DIR__.'/db.php';

function table_exists($t){
  return (int)DB::run(
    "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema=DATABASE() AND table_name=?",
    [$t]
  )->fetchColumn() > 0;
}
function column_exists($t,$c){
  return (int)DB::run(
    "SELECT COUNT(*) FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name=? AND column_name=?",
    [$t,$c]
  )->fetchColumn() > 0;
}
function kv_backend(){
  // প্রাধান্য: settings(name,value) → settings(k,v) → options(k,v)
  $cands = [
    ['t'=>'settings','k'=>'name','v'=>'value'],
    ['t'=>'settings','k'=>'k','v'=>'v'],
    ['t'=>'options','k'=>'k','v'=>'v'],
  ];
  foreach($cands as $c){
    if(table_exists($c['t']) && column_exists($c['t'],$c['k']) && column_exists($c['t'],$c['v'])) return $c;
  }
  // fallback: options বানিয়ে দাও
  DB::run("CREATE TABLE IF NOT EXISTS options (k VARCHAR(64) PRIMARY KEY, v LONGTEXT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
  return ['t'=>'options','k'=>'k','v'=>'v'];
}
function option_get($key,$def=null){
  $b=kv_backend();
  $row=DB::run("SELECT {$b['v']} AS v FROM {$b['t']} WHERE {$b['k']}=?",[$key])->fetch();
  if(!$row) return $def;
  $val=$row['v']; $json=json_decode($val,true);
  return (json_last_error()===JSON_ERROR_NONE)?$json:$val;
}
function option_set($key,$val){
  $b=kv_backend();
  $save=(is_array($val)||is_object($val))?json_encode($val,JSON_UNESCAPED_UNICODE):(string)$val;
  $exists=DB::run("SELECT 1 FROM {$b['t']} WHERE {$b['k']}=?",[$key])->fetch();
  if($exists){
    DB::run("UPDATE {$b['t']} SET {$b['v']}=? WHERE {$b['k']}=?",[$save,$key]);
  }else{
    DB::run("INSERT INTO {$b['t']}({$b['k']},{$b['v']}) VALUES(?,?)",[$key,$save]);
  }
}
