<?php
require_once __DIR__.'/db.php'; require_once __DIR__.'/helpers.php';

function has_table($t){ return (int)DB::run(
  "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema=DATABASE() AND table_name=?",[$t]
)->fetchColumn() > 0; }
function has_cols($t,$cols){
  foreach($cols as $c){
    $ok = (int)DB::run(
      "SELECT COUNT(*) FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name=? AND column_name=?",
      [$t,$c]
    )->fetchColumn();
    if(!$ok) return false;
  }
  return true;
}

/**
 * render_menu_html('main')
 * - যদি site_menus এ label,url,parent_id,sort,menu_key থাকে → সেটাই ইউজ
 * - নাহলে menu_items(menu_key, label, url, parent_id, sort)
 */
function render_menu_html(string $menu_key, string $class='menu'){
  // 1) site_menus?
  if (has_table('site_menus') && has_cols('site_menus',['label','url'])) {
    // সম্ভাব্য কলামগুলো ধরছি
    $parent_col = has_cols('site_menus',['parent_id']) ? 'parent_id' : null;
    $sort_col   = has_cols('site_menus',['sort']) ? 'sort' : 'id';
    $key_filter = has_cols('site_menus',['menu_key']) ? "WHERE menu_key=?" : "";
    $args = has_cols('site_menus',['menu_key']) ? [$menu_key] : [];
    $rows = DB::run("SELECT * FROM site_menus $key_filter ORDER BY ".($parent_col?:'id').", $sort_col", $args)->fetchAll();
    if($rows){
      $children=[];
      foreach($rows as $r){ $pid = $parent_col? $r[$parent_col]: null; $children[$pid][]=$r; }
      $build=function($pid) use (&$build,$children){
        $h='<ul>';
        foreach($children[$pid]??[] as $it){
          $h.='<li><a href="'.e($it['url']).'">'.e($it['label']).'</a>';
          if(!empty($children[$it['id']])) $h.=$build($it['id']);
          $h.='</li>';
        }
        return $h.'</ul>';
      };
      return '<nav class="'.$class.'">'.$build(null).'</nav>';
    }
  }

  // 2) fallback: menu_items
  $rows = DB::run("SELECT * FROM menu_items WHERE menu_key=? ORDER BY parent_id, sort, id",[$menu_key])->fetchAll();
  if(!$rows) return '';
  $children=[]; foreach($rows as $r){ $children[$r['parent_id']][]=$r; }
  $build=function($pid) use (&$build,$children){
    $h='<ul>';
    foreach($children[$pid]??[] as $it){
      $h.='<li><a href="'.e($it['url']).'">'.e($it['label']).'</a>';
      if(!empty($children[$it['id']])) $h.=$build($it['id']);
      $h.='</li>';
    }
    return $h.'</ul>';
  };
  return '<nav class="'.$class.'">'.$build(null).'</nav>';
}
