<?php
// core/helpers.php

function cfg() {
  static $c;
  if (!$c) { $c = require __DIR__ . '/../config.php'; }
  return $c;
}

function base_url($path='') {
  $b = rtrim(cfg()['base_url'] ?? '', '/');
  return $b . '/' . ltrim($path, '/');
}

function e($s) {
  return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

function redirect($path) {
  header('Location: '. base_url($path));
  exit;
}

function asset($path) {
  // cache-buster based on file contents if local
  $full = dirname(__DIR__) . '/public/' . ltrim($path, '/');
  $q = is_file($full) ? ('?v='.substr(md5_file($full), 0, 8)) : '';
  return base_url($path) . $q;
}

function is_post() {
  return strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET') === 'POST';
}

/* ---- CSRF ---- */
function csrf_token() {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['csrf'];
}
function csrf_check($t) {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  return isset($_SESSION['csrf']) && hash_equals($_SESSION['csrf'], (string)$t);
}
