<?php
// core/db.php
class DB {
  private static $pdo;

  public static function pdo() {
    if (!self::$pdo) {
      $cfg = require __DIR__ . '/config.php';

      // ✅ পোর্টও DSN-এ যুক্ত করা হলো
      $dsn = "mysql:host={$cfg['db']['host']};port={$cfg['db']['port']};dbname={$cfg['db']['name']};charset={$cfg['db']['charset']}";

      try {
        self::$pdo = new PDO($dsn, $cfg['db']['user'], $cfg['db']['pass'], [
          PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
          PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
      } catch (PDOException $e) {
        http_response_code(500);
        die("DB connection failed: " . htmlspecialchars($e->getMessage()));
      }
    }
    return self::$pdo;
  }

  public static function run($sql, $args = []) {
    $stmt = self::pdo()->prepare($sql);
    $stmt->execute($args);
    return $stmt;
  }
}
