<?php
// admin/video-category.php — create/list video categories

require_once __DIR__ . '/../core/auth.php';
require_login();
require_role(['admin']);

require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

/* ---------------- helpers ---------------- */
function table_exists($t) {
  return (int) DB::run(
    "SELECT COUNT(*) FROM information_schema.TABLES
     WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ?", [$t]
  )->fetchColumn() > 0;
}

/* ---------------- ensure table ---------------- */
if (!table_exists('video_categories')) {
  DB::run("
    CREATE TABLE video_categories (
      id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      name VARCHAR(150) NOT NULL,
      created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
  ");
}

/* ---------------- create / update ---------------- */
$editing = null;
$name = trim($_POST['name'] ?? '');

if (isset($_GET['edit'])) {
  $editing = (int) $_GET['edit'];
  $row = DB::run("SELECT * FROM video_categories WHERE id=?", [$editing])->fetch();
  if ($row) $name = $row['name'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if ($name === '') {
    $err = 'Name is required.';
  } else {
    if (isset($_POST['id']) && $_POST['id'] !== '') {
      DB::run("UPDATE video_categories SET name=? WHERE id=?", [$name, (int)$_POST['id']]);
    } else {
      DB::run("INSERT INTO video_categories (name) VALUES (?)", [$name]);
    }
    header("Location: video-category.php?saved=1");
    exit;
  }
}

/* ---------------- data ---------------- */
$cats = DB::run("SELECT * FROM video_categories ORDER BY id ASC")->fetchAll();

/* ---------------- UI ---------------- */
include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/sidebar.php';
?>
<style>
.panel{background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:18px}
.grid-2{display:grid;grid-template-columns:380px 1fr;gap:18px}
.table td,.table th{vertical-align:middle}
.btn{display:inline-block;background:#22c55e;color:#fff;border:none;border-radius:10px;padding:10px 16px;cursor:pointer;text-decoration:none}
.btn-edit{font-size:0}
.btn-edit::after{content:"✏️";font-size:16px}
.input{width:100%;padding:10px;border:1px solid #d1d5db;border-radius:8px;background:#fff}
.alert{padding:8px 10px;border-radius:8px;background:#f0fdf4;border:1px solid #bbf7d0;color:#166534;margin-bottom:10px}
</style>

<div class="admin-container">
  <?php if (isset($err)): ?>
    <div class="alert" style="background:#fee2e2;border-color:#fecaca;color:#7f1d1d"><?= e($err) ?></div>
  <?php elseif (isset($_GET['saved'])): ?>
    <div class="alert">Saved.</div>
  <?php endif; ?>

  <div class="grid-2">
    <!-- LEFT: form -->
    <div class="panel">
      <h3>Video Category Form</h3>
      <form method="post">
        <input type="hidden" name="id" value="<?= $editing ? (int)$editing : '' ?>">
        <label style="display:block;margin:10px 0 6px">Name</label>
        <input class="input" type="text" name="name" placeholder="Ex. Breaking News." value="<?= e($name) ?>" required>
        <div style="margin-top:14px">
          <button class="btn">Save</button>
        </div>
      </form>
    </div>

    <!-- RIGHT: list -->
    <div class="panel">
      <h3>All Video Categories</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Name</th><th style="width:80px">Manage</th></tr></thead>
        <tbody>
          <?php if ($cats): $i=1; foreach ($cats as $c): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= e($c['name']) ?></td>
              <td><a class="btn-edit" title="Edit" href="video-category.php?edit=<?= (int)$c['id'] ?>"></a></td>
            </tr>
          <?php endforeach; else: ?>
            <tr><td colspan="3">No categories yet.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/partials/footer.php';
