<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin']);
require_once __DIR__.'/../core/db.php'; require_once __DIR__.'/../core/helpers.php';

$id = isset($_GET['id'])?(int)$_GET['id']:0;
$row = ['division_id'=>'','city_id'=>'','name_bn'=>'','name_en'=>''];
if($id) $row = DB::run("SELECT * FROM upazilas WHERE id=?",[$id])->fetch() ?: $row;

if($_SERVER['REQUEST_METHOD']==='POST'){
  $div=(int)$_POST['division_id']; $city=(int)$_POST['city_id'];
  $nbn=trim($_POST['name_bn']??''); $nen=trim($_POST['name_en']??'');
  if($id){ DB::run("UPDATE upazilas SET division_id=?,city_id=?,name_bn=?,name_en=? WHERE id=?",[$div,$city,$nbn,$nen,$id]); }
  else { DB::run("INSERT INTO upazilas(division_id,city_id,name_bn,name_en) VALUES (?,?,?,?)",[$div,$city,$nbn,$nen]); }
  header("Location: upazila.php".($id?"?id=$id":"")."&saved=1"); exit;
}

$divs = DB::run("SELECT id,name_bn FROM divisions ORDER BY name_bn")->fetchAll();
$cities= DB::run("SELECT id,division_id,name_bn FROM cities ORDER BY name_bn")->fetchAll();
$list = DB::run("SELECT u.*, d.name_bn AS div_name, c.name_bn AS city_name
                 FROM upazilas u
                 LEFT JOIN divisions d ON d.id=u.division_id
                 LEFT JOIN cities c ON c.id=u.city_id
                 ORDER BY d.name_bn, c.name_bn, u.name_bn")->fetchAll();

include __DIR__.'/partials/header.php'; include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Upazila</h2>
  <?php if(isset($_GET['saved'])): ?><div class="alert success">Saved.</div><?php endif;?>
  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Select Division</label>
        <select name="division_id" required id="divSel">
          <option value="">— Select Division —</option>
          <?php foreach($divs as $d): ?>
            <option value="<?= (int)$d['id'] ?>" <?= (int)$row['division_id']===(int)$d['id']?'selected':'' ?>><?= e($d['name_bn']) ?></option>
          <?php endforeach;?>
        </select>

        <label>Select City</label>
        <select name="city_id" required id="citySel">
          <option value="">— Select City —</option>
          <?php foreach($cities as $c): ?>
            <option data-div="<?= (int)$c['division_id'] ?>" value="<?= (int)$c['id'] ?>" <?= (int)$row['city_id']===(int)$c['id']?'selected':'' ?>>
              <?= e($c['name_bn']) ?>
            </option>
          <?php endforeach;?>
        </select>

        <label>Name (BN) *</label><input name="name_bn" required value="<?= e($row['name_bn']) ?>">
        <label>EN Name</label><input name="name_en" value="<?= e($row['name_en']) ?>">
        <button class="btn"><?= $id?'Update':'Save' ?></button> <?php if($id): ?><a class="btn" href="upazila.php">New</a><?php endif;?>
      </form>
    </div>
    <div class="panel">
      <h3>All Upazila</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Division</th><th>City</th><th>Name</th><th>EN</th><th>Edit</th></tr></thead>
        <tbody><?php $i=1; foreach($list as $r): ?>
          <tr>
            <td><?= $i++ ?></td><td><?= e($r['div_name']) ?></td><td><?= e($r['city_name']) ?></td>
            <td><?= e($r['name_bn']) ?></td><td><?= e($r['name_en']) ?></td>
            <td><a class="btn-sm" href="upazila.php?id=<?= (int)$r['id'] ?>">✏️</a></td>
          </tr>
        <?php endforeach; if(!$list): ?><tr><td colspan="6">No data.</td></tr><?php endif;?></tbody>
      </table>
    </div>
  </div>
</div>
<script>
const divSel=document.getElementById('divSel'); const citySel=document.getElementById('citySel');
function filterCities(){ const d=divSel.value; [...citySel.options].forEach(o=>{if(!o.value)return; o.hidden = d && o.dataset.div!==d;}); }
if(divSel&&citySel){ filterCities(); divSel.addEventListener('change',filterCities); }
</script>
</main></div>
<?php include __DIR__.'/partials/footer.php';
