<?php
// admin/partials/sidebar.php
// OPENS the admin layout wrapper:
// <div class="admin-shell"><aside>...</aside><main class="admin-main">
// Close it at the end of each page with: </main></div>

/* ---------- helpers (guarded so they can't redeclare) ---------- */
if (!function_exists('vk_cur_file')) {
  function vk_cur_file(): string {
    // current script without query string
    return basename(parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH));
  }
}
if (!function_exists('is_active')) {
  function is_active($files): string {
    $files = (array)$files;
    return in_array(vk_cur_file(), $files, true) ? 'active' : '';
  }
}
if (!function_exists('grp_open')) {
  function grp_open($files): string {
    $files = (array)$files;
    return in_array(vk_cur_file(), $files, true) ? 'open' : '';
  }
}
$cur = vk_cur_file();
?>
<style>
/* ===== Sidebar with collapsible groups (kept minimal to avoid clashes) ===== */
.admin-shell{display:flex;gap:16px}
.admin-sidebar{
  width:240px;background:#23282d;color:#cfd3da;border-radius:8px;padding:8px 0;
  position:sticky;top:16px;height:fit-content
}
.admin-sidebar .brand{
  font-weight:700;color:#fff;padding:12px 16px;border-bottom:1px solid rgba(255,255,255,.08)
}
.admin-sidebar .grp{border-bottom:1px solid rgba(255,255,255,.06)}
.admin-sidebar .head{
  display:flex;align-items:center;gap:10px;width:100%;padding:10px 16px;background:none;border:0;
  color:#cfd3da;font-weight:600;text-align:left;cursor:pointer
}
.admin-sidebar .caret{margin-left:auto;transition:transform .18s ease}
.admin-sidebar .open .caret{transform:rotate(90deg)}
.admin-sidebar .items{display:none;padding:6px 0 10px}
.admin-sidebar .open .items{display:block}
.admin-sidebar a.item{
  display:flex;align-items:center;gap:10px;padding:8px 32px;color:#cfd3da;text-decoration:none
}
.admin-sidebar a.item:hover,.admin-sidebar a.item.active{background:#2f353b;color:#fff}
.admin-main{flex:1}
</style>

<div class="admin-shell">
  <aside class="admin-sidebar" aria-label="Main menu">
    <div class="brand">Vurrer Kagoj</div>

    <!-- Dashboard -->
    <div class="grp <?= grp_open(['dashboard.php']) ?>">
      <button class="head" type="button">📊 Dashboard <span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= is_active('dashboard.php') ?>" href="dashboard.php">Dashboard home</a>
      </div>
    </div>

    <!-- User Role -->
    <div class="grp <?= grp_open(['users.php']) ?>">
      <button class="head" type="button">👥 User Role Management <span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= is_active('users.php') ?>" href="users.php">Users</a>
      </div>
    </div>

    <!-- Configuration (all requested items kept here) -->
    <div class="grp <?= grp_open([
        'categories.php','city.php','country.php','designation.php','division.php',
        'tag.php','upazila.php','menu_setup.php','section_index.php',
        'section_position_list.php','trending_tag.php'
      ]) ?>">
      <button class="head" type="button">⚙️ Configuration <span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= is_active('categories.php') ?>" href="categories.php">Category</a>
        <a class="item <?= is_active('city.php') ?>" href="city.php">City</a>
        <a class="item <?= is_active('country.php') ?>" href="country.php">Country</a>
        <a class="item <?= is_active('designation.php') ?>" href="designation.php">Designation</a>
        <a class="item <?= is_active('division.php') ?>" href="division.php">Division</a>
        <a class="item <?= is_active('tag.php') ?>" href="tag.php">Tag</a>
        <a class="item <?= is_active('upazila.php') ?>" href="upazila.php">Upazila</a>
        <a class="item <?= is_active('menu_setup.php') ?>" href="menu_setup.php">Menu Setup</a>
        <a class="item <?= is_active('section_index.php') ?>" href="section_index.php">Section index</a>
        <a class="item <?= is_active('section_position_list.php') ?>" href="section_position_list.php">Section Position List</a>
        <a class="item <?= is_active('trending_tag.php') ?>" href="trending_tag.php">Trending Tag</a>
      </div>
    </div>

    <!-- Posts -->
    <div class="grp <?= grp_open(['posts.php','post_edit.php']) ?>">
      <button class="head" type="button">📝 Post <span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= is_active('post_edit.php') ?>" href="post_edit.php">New Post</a>
        <a class="item <?= is_active('posts.php') ?>" href="posts.php">Post List</a>
      </div>
    </div>

    <!-- Ad. Client -->
    <div class="grp <?= grp_open(['ad_clients.php','ad_client_edit.php']) ?>">
      <button class="head" type="button">🏷️ Ad. Client <span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= is_active('ad_client_edit.php') ?>" href="ad_client_edit.php">New Client</a>
        <a class="item <?= is_active('ad_clients.php') ?>" href="ad_clients.php">Client List</a>
      </div>
    </div>

    <!-- Advertisement (placeholder) -->
    <div class="grp">
      <button class="head" type="button">📢 Advertisement <span class="caret">▸</span></button>
      <div class="items">
        <a class="item" href="#">Adsense List</a>
      </div>
    </div>

    <!-- Photo Gallery (placeholder) -->
    <div class="grp">
      <button class="head" type="button">🖼️ Photo Gallery <span class="caret">▸</span></button>
      <div class="items">
        <a class="item" href="#">photo gallery</a>
      </div>
    </div>

    <!-- Video Gallery (placeholder) -->
    <div class="grp">
      <button class="head" type="button">🎬 Video Gallery <span class="caret">▸</span></button>
      <div class="items">
        <a class="item" href="#">Video Gallery</a>
        <a class="item" href="#">Video List</a>
      </div>
    </div>

    <!-- Website / Media -->
    <div class="grp <?= grp_open(['media.php']) ?>">
      <button class="head" type="button">🌐 Website <span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= is_active('media.php') ?>" href="media.php">Media</a>
        <a class="item" href="../" target="_blank" rel="noopener">Visit site</a>
      </div>
    </div>

    <!-- Employee (placeholder) -->
    <div class="grp">
      <button class="head" type="button">🧑‍💼 Employee <span class="caret">▸</span></button>
      <div class="items">
        <a class="item" href="#">Department List</a>
      </div>
    </div>

    <!-- Logout -->
    <div class="grp">
      <a class="item" href="logout.php">🚪 Logout</a>
    </div>
  </aside>

  <main class="admin-main">
    <script>
      // group toggler (kept inline so the partial works anywhere)
      document.querySelectorAll('.admin-sidebar .head').forEach(btn=>{
        btn.addEventListener('click',()=>btn.parentElement.classList.toggle('open'));
      });
    </script>
