<?php
// public footer (dynamic)

/** fetch many settings at once */
function settings_many(array $keys): array {
  if (!$keys) return [];
  $ph = implode(',', array_fill(0, count($keys), '?'));
  $rows = DB::run("SELECT name,value FROM settings WHERE name IN ($ph)", $keys)->fetchAll();
  $m=[]; foreach($rows as $r) $m[$r['name']]=$r['value'];
  foreach($keys as $k) if(!isset($m[$k])) $m[$k]='';
  return $m;
}

/** parse "label|url" per line */
function parse_links($text){
  $out=[]; foreach (preg_split("/\r\n|\n|\r/", trim((string)$text)) as $line){
    $line=trim($line); if($line==='') continue;
    if (strpos($line,'|')!==false){ [$lab,$url]=array_map('trim', explode('|',$line,2)); }
    else { $lab=$line; $url='#'; }
    $out[]=['label'=>$lab,'url'=>$url];
  } return $out;
}

$K = [
  'footer_tagline',
  'foot_col1_title','foot_col1_links',
  'foot_col2_title','foot_col2_links',
  'foot_col3_title','foot_col3_links',
  'foot_col4_title','foot_col4_links',

  'footer_logo','site_name_bn',

  'foot_editor_name_bn','foot_publisher_name_bn',
  'foot_phone','foot_ad_phone','foot_email','foot_office_address_bn',

  'foot_android_url','foot_ios_url',
  'foot_fb','foot_x','foot_yt','foot_in','foot_ig',
  'footer_copyright_bn',
  'footer_html',
];
$S = settings_many($K);
?>

<footer class="vk-footer">
  <div class="vk-foot-top">
    <div class="vk-wrap">
      <h4 class="vk-tagline"><?= e($S['footer_tagline'] ?: 'অনুসন্ধানের জন্য ভিজিট করুন ভোরের আকাশ') ?></h4>
    </div>
  </div>

  <div class="vk-foot-main">
    <div class="vk-wrap vk-grid">

      <div class="vk-col">
        <h5><?= e($S['foot_col1_title']) ?></h5>
        <ul>
          <?php foreach (parse_links($S['foot_col1_links']) as $it): ?>
            <li><a href="<?= e($it['url']) ?>"><?= e($it['label']) ?></a></li>
          <?php endforeach; ?>
        </ul>
      </div>

      <div class="vk-col">
        <h5><?= e($S['foot_col2_title']) ?></h5>
        <ul>
          <?php foreach (parse_links($S['foot_col2_links']) as $it): ?>
            <li><a href="<?= e($it['url']) ?>"><?= e($it['label']) ?></a></li>
          <?php endforeach; ?>
        </ul>
      </div>

      <div class="vk-col">
        <h5><?= e($S['foot_col3_title']) ?></h5>
        <ul>
          <?php foreach (parse_links($S['foot_col3_links']) as $it): ?>
            <li><a href="<?= e($it['url']) ?>"><?= e($it['label']) ?></a></li>
          <?php endforeach; ?>
        </ul>
      </div>

      <div class="vk-col">
        <h5><?= e($S['foot_col4_title']) ?></h5>
        <ul>
          <?php foreach (parse_links($S['foot_col4_links']) as $it): ?>
            <li><a href="<?= e($it['url']) ?>"><?= e($it['label']) ?></a></li>
          <?php endforeach; ?>
        </ul>
      </div>

    </div>
  </div>

  <div class="vk-foot-contact">
    <div class="vk-wrap vk-contact-grid">
      <div class="vk-org">
        <?php if ($S['footer_logo']): ?>
          <img class="vk-footer-logo" src="<?= e($S['footer_logo']) ?>" alt="<?= e($S['site_name_bn']) ?>">
        <?php else: ?>
          <div class="vk-footer-title"><?= e($S['site_name_bn'] ?: 'ভোরের আকাশ') ?></div>
        <?php endif; ?>
      </div>

      <div class="vk-contacts">
        <p>সম্পাদক: <strong><?= e($S['foot_editor_name_bn']) ?></strong></p>
        <p>প্রকাশক: <strong><?= e($S['foot_publisher_name_bn']) ?></strong></p>
        <p>ফোন: <?= e($S['foot_phone']) ?> &nbsp;•&nbsp; বিজ্ঞাপন: <?= e($S['foot_ad_phone']) ?></p>
        <p>ই-মেইল: <a href="mailto:<?= e($S['foot_email']) ?>"><?= e($S['foot_email']) ?></a></p>
        <p><?= nl2br(e($S['foot_office_address_bn'])) ?></p>
      </div>

      <div class="vk-apps">
        <?php if ($S['foot_android_url']): ?>
          <a class="vk-badge" href="<?= e($S['foot_android_url']) ?>" target="_blank" rel="noopener">Get it on Google Play</a>
        <?php endif; ?>
        <?php if ($S['foot_ios_url']): ?>
          <a class="vk-badge" href="<?= e($S['foot_ios_url']) ?>" target="_blank" rel="noopener">Download on the App Store</a>
        <?php endif; ?>

        <div class="vk-social">
          <?php if ($S['foot_fb']): ?><a href="<?= e($S['foot_fb']) ?>" aria-label="Facebook">f</a><?php endif; ?>
          <?php if ($S['foot_x']):  ?><a href="<?= e($S['foot_x']) ?>"  aria-label="X/Twitter">x</a><?php endif; ?>
          <?php if ($S['foot_yt']): ?><a href="<?= e($S['foot_yt']) ?>" aria-label="YouTube">▶</a><?php endif; ?>
          <?php if ($S['foot_in']): ?><a href="<?= e($S['foot_in']) ?>" aria-label="LinkedIn">in</a><?php endif; ?>
          <?php if ($S['foot_ig']): ?><a href="<?= e($S['foot_ig']) ?>" aria-label="Instagram">⌾</a><?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <div class="vk-foot-bottom">
    <div class="vk-wrap vk-bottom-grid">
      <div class="vk-copy"><?= e($S['footer_copyright_bn'] ?: '© ভোরের আকাশ') ?></div>
      <div class="vk-extra"><?= $S['footer_html'] /* raw slot (optional) */ ?></div>
    </div>
  </div>
</footer>

<style>
  .vk-wrap{max-width:1200px;margin:0 auto;padding:0 16px}
  .vk-foot-top{background:#f3f4f6}
  .vk-tagline{margin:0;padding:18px 0;font-size:18px;font-weight:700}

  .vk-foot-main{background:#fafafa;border-top:1px solid #eee}
  .vk-grid{display:grid;grid-template-columns:repeat(4,minmax(0,1fr));gap:18px;padding:26px 0}
  .vk-col h5{margin:0 0 8px;font-size:16px}
  .vk-col ul{list-style:none;margin:0;padding:0}
  .vk-col li{margin:6px 0}
  .vk-col a{text-decoration:none;color:#111}
  .vk-col a:hover{text-decoration:underline}

  .vk-foot-contact{background:#fff;border-top:1px solid #eee}
  .vk-contact-grid{display:grid;grid-template-columns:260px 1fr 260px;gap:18px;padding:22px 0}
  .vk-footer-logo{max-height:44px}
  .vk-footer-title{font-size:22px;font-weight:800}
  .vk-contacts p{margin:6px 0;color:#374151}
  .vk-badge{display:inline-block;border:1px solid #d1d5db;border-radius:8px;padding:8px 12px;margin:4px 6px 0 0;text-decoration:none;color:#111;font-size:13px}
  .vk-social{margin-top:10px}
  .vk-social a{display:inline-flex;width:32px;height:32px;align-items:center;justify-content:center;border:1px solid #d1d5db;border-radius:50%;text-decoration:none;color:#111;margin-right:6px}

  .vk-foot-bottom{background:#0b1220;color:#e5e7eb}
  .vk-bottom-grid{display:flex;gap:16px;align-items:center;justify-content:space-between;padding:14px 0;font-size:14px}
  @media (max-width:980px){
    .vk-grid{grid-template-columns:repeat(2,minmax(0,1fr))}
    .vk-contact-grid{grid-template-columns:1fr}
    .vk-bottom-grid{flex-direction:column;align-items:flex-start}
  }
</style>
