<?php
// admin/section_positions.php
require_once __DIR__ . '/../core/auth.php';
require_login(); require_role(['admin']);
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['pos']) && is_array($_POST['pos'])) {
  // normalize: if duplicate positions are given, we’ll still sort by posted order
  $order = array_map('intval', array_keys($_POST['pos'])); // ids in posted order
  $i = 1;
  foreach ($order as $sid) {
    DB::run("UPDATE home_sections SET position=? WHERE id=?", [$i++, $sid]);
  }
  header("Location: section_positions.php?saved=1"); exit;
}

// move up/down via GET
if (isset($_GET['move'], $_GET['id'])) {
  $id = (int)$_GET['id'];
  $cur = DB::run("SELECT id, position FROM home_sections WHERE id=?", [$id])->fetch();
  if ($cur) {
    if ($_GET['move']==='up')   $swap = DB::run("SELECT id, position FROM home_sections WHERE position < ? ORDER BY position DESC LIMIT 1", [$cur['position']])->fetch();
    if ($_GET['move']==='down') $swap = DB::run("SELECT id, position FROM home_sections WHERE position > ? ORDER BY position ASC  LIMIT 1", [$cur['position']])->fetch();
    if (!empty($swap)) {
      DB::run("UPDATE home_sections SET position=? WHERE id=?", [$swap['position'], $cur['id']]);
      DB::run("UPDATE home_sections SET position=? WHERE id=?", [$cur['position'], $swap['id']]);
    }
  }
  header("Location: section_positions.php"); exit;
}

$rows = DB::run("SELECT * FROM home_sections ORDER BY position ASC, id ASC")->fetchAll();

include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Section Position List</h2>
  <?php if (isset($_GET['saved'])): ?><div class="alert success">Order updated.</div><?php endif; ?>

  <form method="post">
    <div class="panel">
      <p>ড্র্যাগ-এন্ড-ড্রপ না — সরলভাবে, যেভাবে তালিকায় আছে সেভাবেই সেভ হবে। চাইলে Up/Down ব্যবহার করুন।</p>
      <table class="table">
        <thead><tr><th>Pos</th><th>Section</th><th>Slug</th><th>Status</th><th>Action</th></tr></thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
          <tr>
            <td style="width:70px">
              <!-- এই hidden সেটাই order ঠিক করে -->
              <input type="hidden" name="pos[<?= (int)$r['id'] ?>]" value="<?= (int)$r['position'] ?>">
              <?= (int)$r['position'] ?>
            </td>
            <td><?= htmlspecialchars($r['name'],ENT_QUOTES,'UTF-8') ?></td>
            <td><?= htmlspecialchars($r['slug'],ENT_QUOTES,'UTF-8') ?></td>
            <td><?= (int)$r['is_active']? 'Active':'Inactive' ?></td>
            <td style="white-space:nowrap">
              <a class="btn-sm" href="?move=up&id=<?= (int)$r['id'] ?>">↑ Up</a>
              <a class="btn-sm" href="?move=down&id=<?= (int)$r['id'] ?>">↓ Down</a>
              <a class="btn-sm" href="section_index.php?id=<?= (int)$r['id'] ?>">Edit</a>
            </td>
          </tr>
          <?php endforeach; if (!$rows): ?>
            <tr><td colspan="5">No sections.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>

      <button class="btn">Save order</button>
      <a class="btn" href="section_index.php">+ New Section</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
