<?php
// admin/section_index.php — Manage home_sections (no duplicate helpers)

require_once __DIR__ . '/../core/auth.php';
require_login();
require_role(['admin']);

require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

// ---- model/state ----
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$sec = [
  'name'       => '',
  'slug'       => '',
  'rows_count' => 0,
  'cols_count' => 0,
  'position'   => 0,
  'is_active'  => 1,
];

if ($id) {
  $row = DB::run("SELECT * FROM home_sections WHERE id=?", [$id])->fetch();
  if ($row) $sec = $row;
}

// delete
if (isset($_GET['del'])) {
  DB::run("DELETE FROM home_sections WHERE id=?", [(int)$_GET['del']]);
  header("Location: section_index.php?deleted=1");
  exit;
}

// save
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name       = trim($_POST['name'] ?? '');
  $slug       = trim($_POST['slug'] ?? '') ?: null;
  $rows_count = (int)($_POST['rows_count'] ?? 0);
  $cols_count = (int)($_POST['cols_count'] ?? 0);
  $position   = (int)($_POST['position'] ?? 0);
  $is_active  = isset($_POST['is_active']) ? 1 : 0;

  if ($id) {
    DB::run(
      "UPDATE home_sections
          SET name=?, slug=?, rows_count=?, cols_count=?, position=?, is_active=?
        WHERE id=?",
      [$name, $slug, $rows_count, $cols_count, $position, $is_active, $id]
    );
  } else {
    DB::run(
      "INSERT INTO home_sections (name, slug, rows_count, cols_count, position, is_active)
       VALUES (?,?,?,?,?,?)",
      [$name, $slug, $rows_count, $cols_count, $position, $is_active]
    );
    $id = (int) DB::run("SELECT LAST_INSERT_ID()")->fetchColumn();
  }
  header("Location: section_index.php?id={$id}&saved=1");
  exit;
}

// list
$all = DB::run("SELECT * FROM home_sections ORDER BY position, name")->fetchAll();

include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Section index</h2>
  <?php if (isset($_GET['saved'])):   ?><div class="alert success">Saved.</div><?php endif; ?>
  <?php if (isset($_GET['deleted'])): ?><div class="alert">Deleted.</div><?php endif; ?>

  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Name *</label>
        <input name="name" required value="<?= e($sec['name']) ?>">

        <label>Slug (optional, unique)</label>
        <input name="slug" value="<?= e($sec['slug']) ?>">

        <div class="grid-3">
          <div>
            <label>Rows</label>
            <input type="number" name="rows_count" value="<?= (int)$sec['rows_count'] ?>">
          </div>
          <div>
            <label>Cols</label>
            <input type="number" name="cols_count" value="<?= (int)$sec['cols_count'] ?>">
          </div>
          <div>
            <label>Position</label>
            <input type="number" name="position" value="<?= (int)$sec['position'] ?>">
          </div>
        </div>

        <label style="margin-top:10px">
          <input type="checkbox" name="is_active" <?= !empty($sec['is_active']) ? 'checked' : '' ?>> Active
        </label>

        <div style="margin-top:12px">
          <button class="btn"><?= $id ? 'Update' : 'Save' ?></button>
          <?php if ($id): ?><a class="btn" href="section_index.php">New</a><?php endif; ?>
        </div>
      </form>
    </div>

    <div class="panel">
      <h3>All Sections</h3>
      <table class="table">
        <thead>
          <tr>
            <th>#</th><th>Name</th><th>Slug</th>
            <th>Rows</th><th>Cols</th><th>Pos</th><th>Status</th><th>Manage</th>
          </tr>
        </thead>
        <tbody>
          <?php $i=1; foreach ($all as $r): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= e($r['name']) ?></td>
              <td><?= e($r['slug']) ?></td>
              <td><?= (int)$r['rows_count'] ?></td>
              <td><?= (int)$r['cols_count'] ?></td>
              <td><?= (int)$r['position'] ?></td>
              <td><?= $r['is_active'] ? 'Active' : 'Off' ?></td>
              <td>
                <a class="btn-sm" href="section_index.php?id=<?= (int)$r['id'] ?>">Edit</a>
                <a class="btn-sm" style="background:#f44336"
                   href="section_index.php?del=<?= (int)$r['id'] ?>"
                   onclick="return confirm('Delete this section?')">Del</a>
              </td>
            </tr>
          <?php endforeach; if (!$all): ?>
            <tr><td colspan="8">No data.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</main></div>
<?php include __DIR__ . '/partials/footer.php'; ?>
