<?php
require_once __DIR__ . '/../core/auth.php';
require_login();
require_role(['admin','editor']);
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

function col_exists($table,$col){
  return (int)DB::run(
    "SELECT COUNT(*) FROM information_schema.COLUMNS
     WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME=? AND COLUMN_NAME=?",
    [$table,$col]
  )->fetchColumn() > 0;
}

$hasAuthor = col_exists('posts','author_id');

// delete
if (($_GET['action'] ?? '') === 'delete' && isset($_GET['id'])) {
  DB::run("DELETE FROM posts WHERE id=?", [(int)$_GET['id']]);
  header("Location: posts.php?msg=deleted");
  exit;
}

// list
$q   = trim($_GET['q'] ?? '');
$sql = "SELECT p.id, p.title_bn, p.status, p.publish_at,
               c.name_bn AS cat".($hasAuthor?", u.name AS author":"")."
        FROM posts p
        LEFT JOIN categories c ON c.id=p.category_id ".
        ($hasAuthor ? "LEFT JOIN users u ON u.id=p.author_id " : "").
       "WHERE 1 ".($q? "AND (p.title_bn LIKE :q) " : "")."
        ORDER BY COALESCE(p.publish_at, p.created_at) DESC
        LIMIT 100";
$stmt = DB::run($sql, $q? [':q'=>"%$q%"] : []);
$rows = $stmt->fetchAll();

include __DIR__ . '/partials/header.php';

?>
<div class="admin-container">
  <h2>Posts</h2>

  <div style="display:flex;gap:8px;align-items:center;margin-bottom:12px">
    <form method="get" class="form-inline">
      <input type="text" name="q" value="<?= e($q) ?>" placeholder="Search title…" />
      <button class="btn">Search</button>
    </form>
    <a class="btn" href="post_edit.php">+ New Post</a>
  </div>

  <table class="table">
    <thead>
      <tr>
        <th>#</th><th>Title</th><th>Cat</th><?= $hasAuthor?'<th>Author</th>':'' ?><th>Status</th><th>Time</th><th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php $i=1; foreach ($rows as $r): ?>
      <tr>
        <td><?= $i++ ?></td>
        <td><?= e(mb_strimwidth($r['title_bn']??'',0,70,'…','UTF-8')) ?></td>
        <td><?= e($r['cat']??'') ?></td>
        <?= $hasAuthor?'<td>'.e($r['author']??'').'</td>':'' ?>
        <td><?= e($r['status']) ?></td>
        <td><?= e($r['publish_at']) ?></td>
        <td>
          <a class="btn-sm" href="post_edit.php?id=<?= (int)$r['id'] ?>">Edit</a>
          <a class="btn-sm" href="posts.php?action=delete&id=<?= (int)$r['id'] ?>" onclick="return confirm('Delete this post?')">Delete</a>
        </td>
      </tr>
      <?php endforeach; if (!$rows): ?>
      <tr><td colspan="<?= $hasAuthor?7:6 ?>">No data.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
<?php /* sidebar wrapper close */ ?></main></div>
