<?php
// admin/page-edit.php
// Elementor-like page body builder (rows → columns → widgets), same UX as header/footer.

require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin','editor']);
require_once __DIR__.'/../core/db.php';
require_once __DIR__.'/../core/helpers.php';

if (!function_exists('e')) {
  function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}

// Load page
$id = (int)($_GET['id'] ?? 0);
$page = [
  'title'=>'','slug'=>'','status'=>'draft',
  'show_header'=>1,'show_footer'=>1,
  'meta_title'=>'','meta_desc'=>'',
  'blocks'=>'[]' // JSON string (rows→columns→widgets)
];
if ($id) {
  $row = DB::run("SELECT * FROM pages WHERE id=?",[$id])->fetch();
  if ($row) $page = array_merge($page,$row);
}

// --- Read & normalize model from DB ---
$raw = json_decode($page['blocks'] ?: '[]', true);
$layout = (is_array($raw) ? $raw : []);

// Backward-compat: if old "blocks[]" structure (flat widgets) detected, wrap into one row/column
$looks_like_old = $layout && isset($layout[0]) && isset($layout[0]['type']) && !isset($layout[0]['columns']);
if ($looks_like_old) {
  $widgets = [];
  foreach ($layout as $b) {
    $type = $b['type'] ?? 'html';
    $cfg  = [];
    if ($type === 'html') {
      $cfg = ['html' => $b['html'] ?? ''];
    } elseif ($type === 'shortcode') {
      $cfg = ['code' => $b['code'] ?? ''];
    } elseif ($type === 'category' || $type === 'posts') {
      $cfg = [
        'source'      => $type==='posts' ? ($b['source'] ?? 'latest') : 'category',
        'category_id' => $b['category_id'] ?? '',
        'tag'         => $b['tag'] ?? '',
        'limit'       => (int)($b['limit'] ?? 6),
        'layout'      => $b['layout'] ?? 'grid',
        'title'       => $b['title'] ?? '',
      ];
      $type = ($cfg['source']==='latest') ? 'posts' : ($cfg['source']==='tag' ? 'posts' : 'category');
    }
    $widgets[] = ['type'=>$type, 'cfg'=>$cfg];
  }
  $layout = [[ 'columns'=>[[ 'width'=>100, 'spread'=>false, 'widgets'=>$widgets ]] ]];
}

// Default layout for a brand-new page
if (!$layout) {
  $layout = [[
    'columns' => [[
      'width'=>100,'spread'=>false,
      'widgets'=>[
        ['type'=>'heading','cfg'=>['text'=>'Your Title','level'=>'h2','align'=>'left']],
        ['type'=>'html','cfg'=>['html'=>'<p>Start writing your content…</p>']]
      ]
    ]]
  ]];
}
?>
<!doctype html>
<meta charset="utf-8">
<title><?= $id?'Edit':'Create'?> Page</title>
<link rel="stylesheet" href="assets/css/admin.css">
<link rel="stylesheet" href="assets/css/admin-wide.css">

<div class="admin-container admin-shell">
  <?php $top = __DIR__.'/partials/topbar.php'; if (is_file($top)) include $top; ?>

  <div class="panel">
    <div style="display:flex;justify-content:space-between;align-items:center">
      <h2 style="margin:0"><?= $id?'Edit':'Create'?> Page</h2>
      <div>
        <a class="btn" href="pages.php">Pages</a>
        <?php if($id): ?><a class="btn" target="_blank" href="../public/page.php?slug=<?=e($page['slug'])?>">View</a><?php endif; ?>
      </div>
    </div>

    <?php if(!empty($_GET['saved'])): ?><div class="notice">Saved.</div><?php endif; ?>

    <form method="post" action="page-save.php" id="pageForm">
      <input type="hidden" name="id" value="<?=$id?>">
      <!-- Builder JSON (rows→columns→widgets) -->
      <input type="hidden" name="blocks" id="blocks_json">

      <div class="grid-2">
        <div>
          <label>Title</label>
          <input name="title" value="<?=e($page['title'])?>" required>
        </div>
        <div>
          <label>Slug</label>
          <input name="slug" value="<?=e($page['slug'])?>" placeholder="auto-from-title if empty">
        </div>
      </div>

      <div class="grid-4">
        <div>
          <label>Status</label>
          <select name="status">
            <?php foreach(['draft','published'] as $s): ?>
              <option value="<?=$s?>" <?=$page['status']===$s?'selected':''?>><?=$s?></option>
            <?php endforeach;?>
          </select>
        </div>
        <label class="chk"><input type="checkbox" name="show_header" value="1" <?=$page['show_header']?'checked':''?>> Show Header</label>
        <label class="chk"><input type="checkbox" name="show_footer" value="1" <?=$page['show_footer']?'checked':''?>> Show Footer</label>
      </div>

      <div class="grid-2">
        <div>
          <label>Meta Title</label>
          <input name="meta_title" value="<?=e($page['meta_title'])?>">
        </div>
        <div>
          <label>Meta Description</label>
          <input name="meta_desc" value="<?=e($page['meta_desc'])?>">
        </div>
      </div>

      <h3 style="margin-top:18px">Body Builder</h3>

      <div class="toolbar" style="display:flex;gap:8px;margin:8px 0 12px">
        <button type="button" class="btn" id="addRow">+ Row</button>
        <button type="button" class="btn secondary" id="preview">Preview layout JSON</button>
        <button class="btn" style="margin-left:auto" id="saveTop">Save</button>
      </div>

      <div id="canvas" class="canvas"></div>

      <div class="toolbar" style="display:flex;gap:8px;margin-top:14px">
        <button class="btn" id="saveBottom">Save</button>
        <a class="btn" href="page-edit.php?id=<?=$id?>">Reset</a>
      </div>
    </form>
  </div>
</div>

<style>
  .canvas{ display:flex; flex-direction:column; gap:14px }
  .row{ border:1px dashed #cbd5e1; border-radius:12px; padding:10px; background:#fafafa }
  .row-head{ display:flex; align-items:center; justify-content:space-between; margin-bottom:8px }
  .row-cols{ display:flex; gap:10px; flex-wrap:wrap }
  .col{ background:#fff; border:1px solid #e5e7eb; border-radius:10px; padding:10px; flex:1 1 48% }
  .col-head{ display:flex; gap:8px; align-items:center; margin-bottom:8px; flex-wrap:wrap }
  .col .widgets{ display:flex; gap:8px; flex-wrap:wrap; min-height:42px }
  .w{ border:1px solid #d1d5db; background:#fff; padding:6px 8px; border-radius:8px; display:flex; align-items:center; gap:8px }
  .w .grab{ cursor:grab }
  .w .cfg{ width:100% }
  .chip{ font-size:12px; padding:4px 8px; border:1px solid #e5e7eb; border-radius:999px; background:#fff; cursor:pointer }
  .btn-danger{ background:#b91c1c; color:#fff }
  .muted{ color:#666 }
  .small{ font-size:12px }
  .sep{ width:6px; display:inline-block }
  .inline{ display:inline-flex; align-items:center; gap:6px }
  @media (max-width: 900px){ .col{flex-basis:100%} }
</style>

<script>
// ===== Model =====
const initial = <?php echo json_encode($layout, JSON_UNESCAPED_UNICODE); ?>;

// ===== Available widgets =====
const WIDGETS = [
  {type:'heading',   label:'Heading'},
  {type:'html',      label:'HTML'},
  {type:'shortcode', label:'Shortcode'},
  {type:'category',  label:'Posts by Category'},
  {type:'posts',     label:'Latest/By Category/Tag'},
  {type:'banner',    label:'Banner'},
  {type:'spacer',    label:'Spacer'},
  {type:'divider',   label:'Divider'}
];

const el  = (html)=>{const t=document.createElement('template'); t.innerHTML=html.trim(); return t.content.firstChild};
const $id = (id)=>document.getElementById(id);
const canvas = $id('canvas');

// ------- Render -------
function render(){
  canvas.innerHTML = '';
  initial.forEach((row, ri)=>{
    const R = el(`<div class="row" data-ri="${ri}">
      <div class="row-head">
        <strong>Row #${ri+1}</strong>
        <div>
          <button type="button" class="chip addCol">+ Column</button>
          <span class="sep"></span>
          <button type="button" class="chip dupRow">⧉</button>
          <button type="button" class="chip moveUp">↑</button>
          <button type="button" class="chip moveDown">↓</button>
          <button type="button" class="chip btn-danger delRow">Delete</button>
        </div>
      </div>
      <div class="row-cols"></div>
    </div>`);
    const colsWrap = R.querySelector('.row-cols');
    (row.columns||[]).forEach((col, ci)=> colsWrap.appendChild(renderCol(ri,ci,col)));
    canvas.appendChild(R);
  });
  serialize();
}

function renderCol(ri, ci, col){
  const C = el(`<div class="col" data-ri="${ri}" data-ci="${ci}" style="flex-basis:${col.width||100}%">
    <div class="col-head">
      <span class="muted small">Width</span>
      <input type="range" min="10" max="100" value="${col.width||100}" class="wRange">
      <label class="small"><input type="checkbox" class="spread" ${col.spread?'checked':''}> spread</label>
      <button type="button" class="chip addW">+ Widget</button>
      <span class="sep"></span>
      <button type="button" class="chip moveLeft">←</button>
      <button type="button" class="chip moveRight">→</button>
      <button type="button" class="chip dupCol">⧉</button>
      <button type="button" class="chip btn-danger delCol">Delete</button>
    </div>
    <div class="widgets"></div>
  </div>`);
  const wrap = C.querySelector('.widgets');
  (col.widgets||[]).forEach((w, wi)=> wrap.appendChild(renderWidget(ri,ci,wi,w)));
  return C;
}

function renderWidget(ri,ci,wi,w){
  const W = el(`<div class="w" draggable="true" data-ri="${ri}" data-ci="${ci}" data-wi="${wi}">
    <span class="grab">☰</span>
    <select class="type">
      ${WIDGETS.map(x=>`<option value="${x.type}" ${x.type===w.type?'selected':''}>${x.label}</option>`).join('')}
    </select>
    <div class="cfg"></div>
    <button type="button" class="chip btn-danger delW">x</button>
  </div>`);
  injectCfgForm(W.querySelector('.cfg'), w.type, w.cfg||{});
  return W;
}

// ------- Widget mini-forms (no <script> injection) -------
function injectCfgForm(host, type, cfg){
  if(type==='heading'){
    host.innerHTML = `
      <input placeholder="Text" class="i-text" value="${(cfg.text||'').replace(/"/g,'&quot;')}" style="min-width:240px">
      <select class="i-level">
        ${['h1','h2','h3','h4','h5','h6'].map(h=>`<option value="${h}" ${cfg.level===h?'selected':''}>${h.toUpperCase()}</option>`).join('')}
      </select>
      <select class="i-align">
        ${['left','center','right'].map(a=>`<option value="${a}" ${cfg.align===a?'selected':''}>${a}</option>`).join('')}
      </select>`;
  } else if(type==='html'){
    host.innerHTML = `<input placeholder="Inline HTML" class="i-html" value="${(cfg.html||'').replace(/"/g,'&quot;')}" style="min-width:340px">`;
  } else if(type==='shortcode'){
    host.innerHTML = `<input placeholder="[gallery id=12]" class="i-code" value="${(cfg.code||'').replace(/"/g,'&quot;')}" style="min-width:280px">`;
  } else if(type==='category'){
    host.innerHTML = `
      <input placeholder="Category ID" class="i-cat" value="${cfg.category_id||''}" style="width:120px">
      <input type="number" min="1" class="i-limit" value="${Number.isFinite(+cfg.limit)?cfg.limit:6}" style="width:90px" title="Items">
      <select class="i-layout">
        ${['grid','list','lead-list'].map(L=>`<option value="${L}" ${cfg.layout===L?'selected':''}>${L}</option>`).join('')}
      </select>
      <input placeholder="Title (optional)" class="i-title" value="${(cfg.title||'').replace(/"/g,'&quot;')}" style="min-width:220px">`;
  } else if(type==='posts'){
    host.innerHTML = `
      <select class="i-source">
        <option value="latest" ${(!cfg.source || cfg.source==='latest')?'selected':''}>Latest</option>
        <option value="category" ${cfg.source==='category'?'selected':''}>By Category</option>
        <option value="tag" ${cfg.source==='tag'?'selected':''}>By Tag</option>
      </select>
      <span class="inline only-cat"><input placeholder="Category ID" class="i-cat" value="${cfg.category_id||''}" style="width:120px"></span>
      <span class="inline only-tag"><input placeholder="Tag slug" class="i-tag" value="${(cfg.tag||'').replace(/"/g,'&quot;')}" style="width:160px"></span>
      <input type="number" min="1" class="i-limit" value="${Number.isFinite(+cfg.limit)?cfg.limit:6}" style="width:90px" title="Items">
      <select class="i-layout">
        ${['grid','list','cards'].map(L=>`<option value="${L}" ${cfg.layout===L?'selected':''}>${L}</option>`).join('')}
      </select>`;
    refreshPostsVisibility(host);
  } else if(type==='banner'){
    host.innerHTML = `
      <input placeholder="Image URL" class="i-image" value="${(cfg.image||'').replace(/"/g,'&quot;')}" style="min-width:260px">
      <input placeholder="Link (optional)" class="i-link" value="${(cfg.link||'').replace(/"/g,'&quot;')}">
      <label class="small inline"><input type="checkbox" class="i-blank" ${cfg.blank?'checked':''}> new tab</label>`;
  } else if(type==='spacer'){
    host.innerHTML = `<input type="number" min="0" class="i-height" value="${Number.isFinite(+cfg.height)?cfg.height:24}" style="width:120px" title="px"> <span class="small muted">px</span>`;
  } else if(type==='divider'){
    host.innerHTML = `
      <select class="i-style">
        ${['solid','dashed','dotted'].map(s=>`<option value="${s}" ${cfg.style===s?'selected':''}>${s}</option>`).join('')}
      </select>
      <input type="number" min="1" class="i-thick" value="${Number.isFinite(+cfg.thickness)?cfg.thickness:1}" style="width:90px" title="px">`;
  }
}
function refreshPostsVisibility(host){
  const sel = host.querySelector('.i-source'); if(!sel) return;
  const catBox = host.querySelector('.only-cat');
  const tagBox = host.querySelector('.only-tag');
  const toggle = ()=>{
    const v = sel.value || 'latest';
    if (catBox) catBox.style.display = (v==='category') ? 'inline-flex' : 'none';
    if (tagBox) catBox.style.display = (v==='tag') ? 'inline-flex' : 'none';
  };
  toggle();
  sel.addEventListener('change', toggle);
}

// ------- Top controls -------
$id('addRow').onclick = ()=>{ initial.push({columns:[{width:100,spread:false,widgets:[]} ]}); render(); };
['saveTop','saveBottom'].forEach(btnId=>{
  $id(btnId)?.addEventListener('click', ()=> serialize() );
});
document.getElementById('pageForm').addEventListener('submit', ()=> serialize());

// ------- Click handlers -------
canvas.addEventListener('click', (e)=>{
  const row    = e.target.closest('.row');
  const col    = e.target.closest('.col');
  const widget = e.target.closest('.w');

  // Row actions
  if (e.target.classList.contains('addCol')) {
    const i=parseInt(row.dataset.ri);
    initial[i].columns = initial[i].columns||[];
    initial[i].columns.push({width:50,spread:false,widgets:[]});
    render(); return;
  }
  if (e.target.classList.contains('dupRow')) {
    const i=parseInt(row.dataset.ri);
    initial.splice(i+1,0,JSON.parse(JSON.stringify(initial[i])));
    render(); return;
  }
  if (e.target.classList.contains('delRow')) {
    initial.splice(parseInt(row.dataset.ri),1);
    if (!initial.length) initial.push({columns:[{width:100,widgets:[]} ]});
    render(); return;
  }
  if (e.target.classList.contains('moveUp')) {
    const i=parseInt(row.dataset.ri); if(i>0){ const t=initial[i]; initial[i]=initial[i-1]; initial[i-1]=t; }
    render(); return;
  }
  if (e.target.classList.contains('moveDown')) {
    const i=parseInt(row.dataset.ri); if(i<initial.length-1){ const t=initial[i]; initial[i]=initial[i+1]; initial[i+1]=t; }
    render(); return;
  }

  // Column actions
  if (e.target.classList.contains('delCol')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    initial[ri].columns.splice(ci,1);
    if(!initial[ri].columns.length) initial[ri].columns=[{width:100,widgets:[]}];
    render(); return;
  }
  if (e.target.classList.contains('dupCol')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    const clone = JSON.parse(JSON.stringify(initial[ri].columns[ci]));
    initial[ri].columns.splice(ci+1,0,clone);
    render(); return;
  }
  if (e.target.classList.contains('moveLeft')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    if (ci>0){ const arr=initial[ri].columns; const t=arr[ci]; arr[ci]=arr[ci-1]; arr[ci-1]=t; }
    render(); return;
  }
  if (e.target.classList.contains('moveRight')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    const arr=initial[ri].columns;
    if (ci<arr.length-1){ const t=arr[ci]; arr[ci]=arr[ci+1]; arr[ci+1]=t; }
    render(); return;
  }
  if (e.target.classList.contains('addW')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    initial[ri].columns[ci].widgets = initial[ri].columns[ci].widgets||[];
    initial[ri].columns[ci].widgets.push({type:'heading',cfg:{text:'Heading',level:'h3',align:'left'}});
    render(); return;
  }

  // Widget delete
  if (e.target.classList.contains('delW')) {
    const ri=parseInt(widget.dataset.ri), ci=parseInt(widget.dataset.ci), wi=parseInt(widget.dataset.wi);
    initial[ri].columns[ci].widgets.splice(wi,1);
    render(); return;
  }
});

// ------- Change handlers -------
canvas.addEventListener('change', (e)=>{
  const col    = e.target.closest('.col');
  const widget = e.target.closest('.w');

  if (e.target.classList.contains('wRange')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    initial[ri].columns[ci].width = parseInt(e.target.value);
    col.style.flexBasis = e.target.value+'%';
    serialize(); return;
  }
  if (e.target.classList.contains('spread')) {
    const ri=parseInt(col.dataset.ri), ci=parseInt(col.dataset.ci);
    initial[ri].columns[ci].spread = e.target.checked;
    serialize(); return;
  }
  if (e.target.classList.contains('type')) {
    const ri=parseInt(widget.dataset.ri), ci=parseInt(widget.dataset.ci), wi=parseInt(widget.dataset.wi);
    const type = e.target.value;
    initial[ri].columns[ci].widgets[wi] = {type, cfg:{}};
    injectCfgForm(widget.querySelector('.cfg'), type, {});
    serialize(); return;
  }

  // Update widget cfg (live)
  if (widget) {
    const ri=parseInt(widget.dataset.ri), ci=parseInt(widget.dataset.ci), wi=parseInt(widget.dataset.wi);
    const node = initial[ri].columns[ci].widgets[wi];
    const cfg  = node.cfg || {};
    switch(node.type){
      case 'heading':
        cfg.text   = widget.querySelector('.i-text')?.value || '';
        cfg.level  = widget.querySelector('.i-level')?.value || 'h2';
        cfg.align  = widget.querySelector('.i-align')?.value || 'left';
        break;
      case 'html':
        cfg.html = widget.querySelector('.i-html')?.value || '';
        break;
      case 'shortcode':
        cfg.code = widget.querySelector('.i-code')?.value || '';
        break;
      case 'category':
        cfg.category_id = widget.querySelector('.i-cat')?.value || '';
        cfg.limit = +widget.querySelector('.i-limit')?.value || 6;
        cfg.layout = widget.querySelector('.i-layout')?.value || 'grid';
        cfg.title = widget.querySelector('.i-title')?.value || '';
        break;
      case 'posts':
        cfg.source = widget.querySelector('.i-source')?.value || 'latest';
        refreshPostsVisibility(widget.querySelector('.cfg'));
        cfg.category_id = (cfg.source==='category') ? (widget.querySelector('.i-cat')?.value || '') : '';
        cfg.tag = (cfg.source==='tag') ? (widget.querySelector('.i-tag')?.value || '') : '';
        cfg.limit = +widget.querySelector('.i-limit')?.value || 6;
        cfg.layout = widget.querySelector('.i-layout')?.value || 'grid';
        break;
      case 'banner':
        cfg.image = widget.querySelector('.i-image')?.value || '';
        cfg.link  = widget.querySelector('.i-link')?.value || '';
        cfg.blank = !!widget.querySelector('.i-blank')?.checked;
        break;
      case 'spacer':
        cfg.height = +widget.querySelector('.i-height')?.value || 24;
        break;
      case 'divider':
        cfg.style = widget.querySelector('.i-style')?.value || 'solid';
        cfg.thickness = +widget.querySelector('.i-thick')?.value || 1;
        break;
    }
    node.cfg = cfg;
    serialize();
  }
});

// ------- Drag & drop widgets -------
let dragEl=null;
canvas.addEventListener('dragstart', e=>{
  const w=e.target.closest('.w'); if(!w) return;
  dragEl=w; e.dataTransfer.effectAllowed='move'; w.style.opacity='.5';
});
document.addEventListener('dragend', ()=>{ if(dragEl){dragEl.style.opacity=''; dragEl=null;} });
canvas.addEventListener('dragover', e=>{
  const zone=e.target.closest('.widgets'); if(!zone) return;
  e.preventDefault();
  const after=[...zone.querySelectorAll('.w')].find(b=>{
    const r=b.getBoundingClientRect(); return e.clientX < r.left + r.width/2;
  });
  if(!after) zone.appendChild(dragEl); else zone.insertBefore(dragEl, after);
});
document.addEventListener('drop', ()=>{
  // rebuild model from DOM after drag
  const rows=[...canvas.querySelectorAll('.row')].map(R=>{
    const cols=[...R.querySelectorAll('.col')].map(C=>{
      const width=parseInt(C.querySelector('.wRange').value||100);
      const spread=C.querySelector('.spread').checked;
      const widgets=[...C.querySelectorAll('.w')].map(W=>{
        const type=W.querySelector('.type').value;
        let cfg={};
        const g=(sel)=>W.querySelector(sel);
        switch(type){
          case 'heading':  cfg={text:g('.i-text')?.value||'', level:g('.i-level')?.value||'h2', align:g('.i-align')?.value||'left'}; break;
          case 'html':     cfg={html:g('.i-html')?.value||''}; break;
          case 'shortcode':cfg={code:g('.i-code')?.value||''}; break;
          case 'category': cfg={category_id:g('.i-cat')?.value||'', limit:+(g('.i-limit')?.value||6), layout:g('.i-layout')?.value||'grid', title:g('.i-title')?.value||''}; break;
          case 'posts':
            const src=g('.i-source')?.value||'latest';
            cfg={source:src, category_id: src==='category'?(g('.i-cat')?.value||''):'', tag: src==='tag'?(g('.i-tag')?.value||''):'', limit:+(g('.i-limit')?.value||6), layout:g('.i-layout')?.value||'grid'};
            break;
          case 'banner':   cfg={image:g('.i-image')?.value||'', link:g('.i-link')?.value||'', blank:!!g('.i-blank')?.checked}; break;
          case 'spacer':   cfg={height:+(g('.i-height')?.value||24)}; break;
          case 'divider':  cfg={style:g('.i-style')?.value||'solid', thickness:+(g('.i-thick')?.value||1)}; break;
        }
        return {type, cfg};
      });
      return {width, spread, widgets};
    });
    return {columns:cols};
  });
  initial.splice(0, initial.length, ...rows);
  serialize();
});

// ------- Serialize & Preview -------
function serialize(){ $id('blocks_json').value = JSON.stringify(initial); }
$id('preview').onclick = ()=>{ serialize(); alert($id('blocks_json').value); };

render();
</script>
