<?php
// admin/partials/sidebar.php
// Standalone LEFT SIDEBAR ONLY (no wrappers). Safe to include from any page.

// figure out the current file once (works even behind query strings)
$__vk_cur = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

// helpers with unique names so they never "redeclare"
if (!function_exists('__vk_is_active')) {
  function __vk_is_active($files) {
    $files = (array)$files;
    $cur   = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    return in_array($cur, $files, true) ? 'active' : '';
  }
}
if (!function_exists('__vk_is_open')) {
  function __vk_is_open($files) {
    $files = (array)$files;
    $cur   = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    return in_array($cur, $files, true) ? 'open' : '';
  }
}
?>
<style>
/* === Dashboard-like dark sidenav (self-contained) === */
.sidenav{
  width: 270px;
  background:#121922;
  color:#cfd6df;
  border-radius:12px;
  padding:8px 0 10px;
  position:sticky; top:14px; height:fit-content;
  box-shadow:0 4px 18px rgba(0,0,0,.18)
}
.sidenav .brand{
  font-weight:700; color:#fff; padding:14px 18px; font-size:18px;
  border-bottom:1px solid rgba(255,255,255,.06)
}
.sidenav .grp{border-bottom:1px solid rgba(255,255,255,.05)}
.sidenav .head{
  width:100%; background:none; border:0; cursor:pointer;
  color:#cfd6df; display:flex; align-items:center; gap:12px;
  padding:14px 18px; text-align:left; font-weight:600; font-size:15px
}
.sidenav .caret{margin-left:auto; opacity:.85; transition:transform .2s ease}
.sidenav .open .caret{transform:rotate(90deg)}
.sidenav .items{display:none; padding:0 0 10px}
.sidenav .open .items{display:block}
.sidenav .item{
  display:flex; align-items:center; gap:10px; padding:10px 38px 10px 42px;
  color:#cfd6df; text-decoration:none; font-size:14px; border-left:2px solid transparent
}
.sidenav .item:hover{background:#1b2430; color:#fff}
.sidenav .item.active{background:#1f2937; color:#fff; border-left-color:#5aa9ff}
.sidenav .items .item + .item{margin-top:2px}

/* compact icon sizes (emoji, no external icon set) */
.sidenav .head .ico, .sidenav .item .ico{width:18px; text-align:center}

/* small screen: allow the page content overlap if needed */
@media (max-width: 1024px){
  .sidenav{position:relative; top:0}
}
</style>

<aside class="sidenav" aria-label="Sidebar navigation">
  <div class="brand">Vurrer Kagoj</div>
 <!-- Dashboard -->
    <div class="grp <?= $openDash?'open':'' ?>">
      <button class="head" type="button">
        <span>📊 Dashboard</span><span class="caret">▸</span>
      </button>
      <div class="items">
        <a class="item <?= $cur==='dashboard.php'?'active':'' ?>" href="dashboard.php">Dashboard home</a>
      </div>
    </div>

    <!-- User Role -->
    <div class="grp <?= $openUsers?'open':'' ?>">
      <button class="head" type="button">
        <span>👥 User Role Management</span><span class="caret">▸</span>
      </button>
      <div class="items">
        <a class="item <?= $cur==='users.php'?'active':'' ?>" href="users.php">Users</a>
      </div>
    </div>

    <!-- Configuration (ALL items) -->
    <div class="grp <?= $openConf?'open':'' ?>">
      <button class="head" type="button">
        <span>⚙️ Configuration</span><span class="caret">▸</span>
      </button>
      <div class="items">
        <?php
          // Smart link: use categories.php if it exists, otherwise category.php
          $catPage = file_exists(__DIR__.'/categories.php') ? 'categories.php' : (file_exists(__DIR__.'/category.php') ? 'category.php' : 'categories.php');
        ?>
        <a class="item <?= in_array($cur,['categories.php','category.php'],true)?'active':'' ?>" href="<?= $catPage ?>">Category</a>

        <a class="item <?= $cur==='city.php'?'active':'' ?>" href="city.php">City</a>
        <a class="item <?= $cur==='country.php'?'active':'' ?>" href="country.php">Country</a>
        <a class="item <?= $cur==='designation.php'?'active':'' ?>" href="designation.php">Designation</a>
        <a class="item <?= $cur==='division.php'?'active':'' ?>" href="division.php">Division</a>
        <a class="item <?= $cur==='tag.php'?'active':'' ?>" href="tag.php">Tag</a>
        <a class="item <?= $cur==='upazila.php'?'active':'' ?>" href="upazila.php">Upazila</a>
        <a class="item <?= $cur==='menu_setup.php'?'active':'' ?>" href="menu_setup.php">Menu Setup</a>
        <a class="item <?= $cur==='section_index.php'?'active':'' ?>" href="section_index.php">Section index</a>
        <a class="item <?= $cur==='section_position_list.php'?'active':'' ?>" href="section_position_list.php">Section Position List</a>
        <a class="item <?= $cur==='trending_tag.php'?'active':'' ?>" href="trending_tag.php">Trending Tag</a>
      </div>
    </div>

    <!-- Post -->
    <div class="grp <?= $openPost?'open':'' ?>">
      <button class="head" type="button">
        <span>📝 Post</span><span class="caret">▸</span>
      </button>
      <div class="items">
        <a class="item <?= $cur==='post_edit.php'?'active':'' ?>" href="post_edit.php">New Post</a>
        <a class="item <?= $cur==='posts.php'?'active':'' ?>" href="posts.php">Post List</a>
      </div>
    </div>

    <!-- Ad Client -->
    <div class="grp <?= $openClients?'open':'' ?>">
      <button class="head" type="button"><span>🏷️ Ad. Client</span><span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= $cur==='ad_client_edit.php'?'active':'' ?>" href="ad_client_edit.php">New Client</a>
        <a class="item <?= $cur==='ad_clients.php'?'active':'' ?>" href="ad_clients.php">Client List</a>
      </div>
    </div>

    <!-- Advertisement (placeholder) -->
    <div class="grp">
      <button class="head" type="button"><span>📢 Advertisement</span><span class="caret">▸</span></button>
      <div class="items">
	   <a class="item <?= $cur==='adsenses.php'?'active':'' ?>" href="adsenses.php">
        Adsense List</a>
      </div>
    </div>

    <!-- Photo Gallery (placeholder) -->
    <div class="grp">
      <button class="head" type="button"><span>🖼️ Photo Gallery</span><span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= $cur==='photo.php'?'active':'' ?>" href="photo.php">photo gallery</a>
      </div>
    </div>

    <!-- Video Gallery (placeholder) -->
    <div class="grp">
      <button class="head" type="button"><span>🎬 Video Gallery</span><span class="caret">▸</span></button>
      <div class="items">
         <a class="item <?= $cur==='photo.php'?'active':'' ?>" href="video-category.php">Video Gallery</a>
         <a class="item <?= $cur==='photo.php'?'active':'' ?>" href="video.php">Video List</a>
      </div>
    </div>

    <!-- Website -->
    <div class="grp <?= $openMedia?'open':'' ?>">
      <button class="head" type="button"><span>🌐 Website</span><span class="caret">▸</span></button>
      <div class="items">
        <a class="item <?= $cur==='media.php'?'active':'' ?>" href="media.php">Media</a>
        <a class="item" href="../" target="_blank">Visit site</a>
      </div>
    </div>

    <!-- Employee (placeholder) -->
    <div class="grp">
      <button class="head" type="button"><span>🧑‍💼 Employee</span><span class="caret">▸</span></button>
      <div class="items">
        <a class="item" href="#">Department List</a>
		<li><a href="pages.php">📄 Pages</a></li>
        <li><a href="page-edit.php">＋ Create Page</a></li>
        <li><a href="appearance-header.php">🎨 Header Builder</a></li>
        <li><a href="appearance-footer.php">🎨 Footer Builder</a></li>
         <li><a href="media.php">🖼️ Media</a></li>

      </div>
    </div>

    <div class="grp">
      <a class="item" href="logout.php">🚪 Logout</a>
    </div>
  </aside>

<script>
// Bind once so repeated includes don't duplicate listeners
if (!window.__vkSideNavBound) {
  window.__vkSideNavBound = true;
  document.querySelectorAll('.sidenav .head').forEach(btn=>{
    btn.addEventListener('click',()=>btn.parentElement.classList.toggle('open'));
  });
}
</script>
