<?php
// admin/pages.php — list & manage pages

require_once __DIR__.'/../core/auth.php';  require_login();  require_role(['admin','editor']);
require_once __DIR__.'/../core/db.php';
require_once __DIR__.'/../core/helpers.php';
require_once __DIR__.'/../core/options.php';

$home_id = (int) option_get('home_page_id', 0);
$rows    = DB::run("SELECT * FROM pages ORDER BY updated_at DESC")->fetchAll();
?>
<!doctype html>
<meta charset="utf-8">
<title>Pages</title>
<link rel="stylesheet" href="assets/css/admin.css">
<link rel="stylesheet" href="assets/css/admin-wide.css">

<div class="admin-container admin-shell">
  <?php $__top = __DIR__.'/partials/topbar.php'; if (file_exists($__top)) include $__top; ?>

  <div class="panel">
    <div style="display:flex;justify-content:space-between;align-items:center">
      <h2 style="margin:0">Pages</h2>
      <a class="btn" href="page-edit.php">+ Create Page</a>
    </div>

    <?php if (!$rows): ?>
      <p style="margin-top:12px">No pages yet. Click <strong>+ Create Page</strong> to add one.</p>
    <?php else: ?>
      <table class="table">
        <thead>
          <tr>
            <th style="width:34%">Title</th>
            <th style="width:22%">Slug</th>
            <th style="width:10%">Status</th>
            <th style="width:18%">Updated</th>
            <th style="width:6%">Home</th>
            <th style="width:10%"></th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= e($r['title']) ?></td>
            <td>/page/<?= e($r['slug']) ?></td>
            <td><?= e($r['status']) ?></td>
            <td><?= e($r['updated_at']) ?></td>
            <td><?= $home_id === (int)$r['id'] ? '✓' : '' ?></td>
            <td>
              <a class="btn-sm" href="page-edit.php?id=<?= (int)$r['id'] ?>">Edit</a>
              <a class="btn-sm" href="../public/page.php?slug=<?= e($r['slug']) ?>" target="_blank">View</a>
              <?php if ($home_id !== (int)$r['id']): ?>
                <a class="btn-sm" href="page-set-home.php?id=<?= (int)$r['id'] ?>" onclick="return confirm('Make this the homepage?')">Make Home</a>
              <?php else: ?>
                <span class="btn-sm" style="opacity:.6;cursor:default">Home</span>
              <?php endif; ?>
              <a class="btn-sm" style="background:#b91c1c"
                 href="page-delete.php?id=<?= (int)$r['id'] ?>"
                 onclick="return confirm('Delete this page?')">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
</div>
