<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin','editor']);
require_once __DIR__.'/../core/db.php';

/* ---------- Basic fields ---------- */
$id     = (int)($_POST['id'] ?? 0);
$title  = trim($_POST['title'] ?? '');
$slug   = trim($_POST['slug'] ?? '');
$status = in_array($_POST['status'] ?? 'draft', ['draft','published'], true) ? ($_POST['status'] ?? 'draft') : 'draft';
$show_header = !empty($_POST['show_header']) ? 1 : 0;
$show_footer = !empty($_POST['show_footer']) ? 1 : 0;
$meta_title  = trim($_POST['meta_title'] ?? '');
$meta_desc   = trim($_POST['meta_desc'] ?? '');

/* Optional: auto-slug if empty */
if ($slug === '' && $title !== '') {
  $slug = strtolower(trim(preg_replace('~[^a-z0-9]+~i', '-', $title), '-'));
}

/* ---------- Body builder blocks (accept JSON string OR array) ---------- */
$raw = $_POST['blocks'] ?? '[]';
if (is_string($raw)) {
  $blocks = json_decode($raw, true);
  if (!is_array($blocks)) { $blocks = []; }
} elseif (is_array($raw)) {
  $blocks = $raw; // old form posts
} else {
  $blocks = [];
}

/* Normalize & sanitize a bit */
$norm = [];
foreach ($blocks as $b) {
  $type = isset($b['type']) ? preg_replace('~[^a-z]~', '', (string)$b['type']) : 'html';
  // most builders use "cfg" for options; support both cfg and other payloads
  $cfg  = [];
  if (isset($b['cfg']) && is_array($b['cfg'])) {
    $cfg = $b['cfg'];
  } else {
    // fallbacks for old simple editor fields
    foreach ($b as $k=>$v) {
      if ($k === 'type') continue;
      $cfg[$k] = $v;
    }
  }
  $norm[] = ['type'=>$type, 'cfg'=>$cfg];
}
$blocks_json = json_encode($norm, JSON_UNESCAPED_UNICODE);

/* ---------- Save ---------- */
if ($id) {
  DB::run(
    "UPDATE pages
       SET title=?, slug=?, status=?, show_header=?, show_footer=?, meta_title=?, meta_desc=?, blocks=?
     WHERE id=?",
    [$title,$slug,$status,$show_header,$show_footer,$meta_title,$meta_desc,$blocks_json,$id]
  );
} else {
  DB::run(
    "INSERT INTO pages (title,slug,status,show_header,show_footer,meta_title,meta_desc,blocks)
     VALUES (?,?,?,?,?,?,?,?)",
    [$title,$slug,$status,$show_header,$show_footer,$meta_title,$meta_desc,$blocks_json]
  );
  $id = DB::lastInsertId();
}

header("Location: page-edit.php?id=".$id."&saved=1");
