<?php
// admin/page-edit.php — Page Builder editor (header/footer aware + blocks UI)

require_once __DIR__.'/../core/auth.php';
require_login();
require_role(['admin','editor']);

require_once __DIR__.'/../core/db.php';
require_once __DIR__.'/../core/helpers.php';

// load existing row if editing
$id   = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$row  = ['title'=>'','slug'=>'','status'=>'draft','show_header'=>1,'show_footer'=>1,'meta_title'=>'','meta_desc'=>'','blocks'=>'[]'];
if ($id) {
  $r = DB::run("SELECT * FROM pages WHERE id=?",[$id])->fetch();
  if ($r) $row = $r;
}
$blocks = json_decode($row['blocks'] ?: '[]', true) ?: [];

// ---------- view helpers ----------
function block_editor($i, $type, $cfg){
  $cfg = is_array($cfg) ? $cfg : [];
  ob_start(); ?>
  <div class="block" data-idx="<?=$i?>">
    <div class="block-head">
      <strong>Block #<?=($i+1)?></strong>
      <div class="actions">
        <button type="button" class="btn-sm" onclick="moveUp(this)">↑</button>
        <button type="button" class="btn-sm" onclick="moveDown(this)">↓</button>
        <button type="button" class="btn-sm" onclick="dupBlock(this)">⧉</button>
        <button type="button" class="btn-sm danger" onclick="delBlock(this)">✕</button>
      </div>
    </div>

    <div class="grid-2">
      <div>
        <label>Type</label>
        <select name="blocks[<?=$i?>][type]" class="type-select" onchange="switchType(this)">
          <?php
          $types = ['html'=>'HTML','posts'=>'Posts','hero'=>'Hero','pages'=>'Pages List','shortcode'=>'Shortcode'];
          foreach($types as $k=>$label){
            $sel = $k===$type?'selected':'';
            echo "<option value=\"$k\" $sel>$label</option>";
          }
          ?>
        </select>
      </div>

      <div class="type-fields">
        <!-- HTML -->
        <div class="tf tf-html" <?= $type==='html'?'':'style="display:none"' ?>>
          <label>HTML</label>
          <textarea name="blocks[<?=$i?>][cfg][html]" rows="5"><?=htmlspecialchars($cfg['html']??'')?></textarea>
        </div>

        <!-- POSTS -->
        <div class="tf tf-posts" <?= $type==='posts'?'':'style="display:none"' ?>>
          <div class="grid-3">
            <div>
              <label>Layout</label>
              <select name="blocks[<?=$i?>][cfg][layout]">
                <?php
                $opts = ['rail'=>'Top Rail','lead'=>'Lead + 2','mini'=>'Right Mini List','grid4'=>'Grid x4','grid'=>'Grid (default)'];
                $v = $cfg['layout'] ?? 'grid';
                foreach($opts as $k=>$lab){ $sel = $v===$k?'selected':''; echo "<option value=\"$k\" $sel>$lab</option>";}
                ?>
              </select>
            </div>
            <div>
              <label>Category Slug (optional)</label>
              <input name="blocks[<?=$i?>][cfg][cat_slug]" value="<?=e($cfg['cat_slug']??'')?>" placeholder="e.g. national">
            </div>
            <div>
              <label>Limit</label>
              <input type="number" min="1" max="48" name="blocks[<?=$i?>][cfg][limit]" value="<?=e($cfg['limit']??8)?>">
            </div>
          </div>
          <div>
            <label>Section Title (optional)</label>
            <input name="blocks[<?=$i?>][cfg][title]" value="<?=e($cfg['title']??'')?>" placeholder="Shown for grid sections">
          </div>
        </div>

        <!-- HERO -->
        <div class="tf tf-hero" <?= $type==='hero'?'':'style="display:none"' ?>>
          <div class="grid-2">
            <div>
              <label>Title</label>
              <input name="blocks[<?=$i?>][cfg][title]" value="<?=e($cfg['title']??'')?>">
            </div>
            <div>
              <label>Subtitle</label>
              <input name="blocks[<?=$i?>][cfg][subtitle]" value="<?=e($cfg['subtitle']??'')?>">
            </div>
          </div>
          <div class="grid-3">
            <div>
              <label>Image URL</label>
              <input name="blocks[<?=$i?>][cfg][image]" value="<?=e($cfg['image']??'')?>" placeholder="/uploads/...">
            </div>
            <div>
              <label>CTA Text</label>
              <input name="blocks[<?=$i?>][cfg][cta_text]" value="<?=e($cfg['cta_text']??'')?>" placeholder="Read more">
            </div>
            <div>
              <label>CTA URL</label>
              <input name="blocks[<?=$i?>][cfg][cta_url]" value="<?=e($cfg['cta_url']??'#')?>">
            </div>
          </div>
        </div>

        <!-- PAGES list -->
        <div class="tf tf-pages" <?= $type==='pages'?'':'style="display:none"' ?>>
          <label>Page IDs (comma separated)</label>
          <input name="blocks[<?=$i?>][cfg][ids]" value="<?=e($cfg['ids']??'')?>" placeholder="e.g. 2,5,8">
        </div>

        <!-- SHORTCODE -->
        <div class="tf tf-shortcode" <?= $type==='shortcode'?'':'style="display:none"' ?>>
          <label>Shortcode / Snippet</label>
          <textarea name="blocks[<?=$i?>][cfg][code]" rows="3"><?=htmlspecialchars($cfg['code']??'')?></textarea>
        </div>
      </div>
    </div>
  </div>
  <?php
  return ob_get_clean();
}

?>
<!doctype html>
<meta charset="utf-8">
<title><?= $id ? 'Edit Page' : 'Create Page' ?></title>
<link rel="stylesheet" href="assets/css/admin.css">
<link rel="stylesheet" href="assets/css/admin-wide.css">

<div class="admin-container admin-shell">
  <?php $__top = __DIR__.'/partials/topbar.php'; if (file_exists($__top)) include $__top; ?>
  <form method="post" action="page-save.php" id="builderForm">
    <input type="hidden" name="id" value="<?=e($id)?>">
    <div class="panel">
      <h2 style="margin-top:0"><?= $id ? 'Edit Page' : 'Create Page' ?></h2>

      <div class="grid-2">
        <div>
          <label>Title</label>
          <input name="title" value="<?=e($row['title'])?>" required>
        </div>
        <div>
          <label>Slug</label>
          <input name="slug" value="<?=e($row['slug'])?>" placeholder="home, about, contact" required>
        </div>
      </div>

      <div class="grid-3">
        <div>
          <label>Status</label>
          <select name="status">
            <option value="draft"   <?=$row['status']==='draft'?'selected':''?>>draft</option>
            <option value="published" <?=$row['status']==='published'?'selected':''?>>published</option>
          </select>
        </div>
        <div style="display:flex;gap:16px;align-items:center">
          <label><input type="checkbox" name="show_header" value="1" <?=$row['show_header']?'checked':''?>> Show Header</label>
          <label><input type="checkbox" name="show_footer" value="1" <?=$row['show_footer']?'checked':''?>> Show Footer</label>
        </div>
      </div>

      <div class="grid-2">
        <div>
          <label>Meta Title</label>
          <input name="meta_title" value="<?=e($row['meta_title']??'')?>">
        </div>
        <div>
          <label>Meta Description</label>
          <input name="meta_desc" value="<?=e($row['meta_desc']??'')?>">
        </div>
      </div>
    </div>

    <div class="panel">
      <div style="display:flex;justify-content:space-between;align-items:center">
        <h3 style="margin:0">Blocks</h3>
        <button type="button" class="btn" onclick="addBlock()">+ Add Block</button>
      </div>

      <div id="blocks">
        <?php
        if ($blocks) {
          foreach ($blocks as $i=>$b) {
            echo block_editor($i, $b['type'] ?? 'html', $b['cfg'] ?? []);
          }
        } else {
          // new page — start with one HTML block
          echo block_editor(0, 'html', ['html'=>'<h2>Hello</h2>']);
        }
        ?>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px">
        <button class="btn">Save</button>
        <a class="btn secondary" href="pages.php">Back</a>
      </div>
    </div>
  </form>
</div>

<style>
.block{border:1px solid #e5e7eb;border-radius:12px;padding:12px;margin:12px 0;background:#fff}
.block-head{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}
.block .actions .btn-sm{margin-left:6px}
.grid-2{display:grid;grid-template-columns:1fr 1fr;gap:12px}
.grid-3{display:grid;grid-template-columns:1fr 1fr 1fr;gap:12px}
label{display:block;margin-bottom:6px;font-weight:600}
input,select,textarea{width:100%;border:1px solid #d1d5db;border-radius:10px;padding:8px 10px}
.btn{display:inline-block;background:#0f172a;color:#fff;border:none;border-radius:10px;padding:10px 14px;text-decoration:none;cursor:pointer}
.btn-sm{background:#0f172a;color:#fff;border:none;border-radius:8px;padding:6px 10px;cursor:pointer}
.btn-sm.danger{background:#b91c1c}
.type-fields textarea{min-height:120px}
</style>

<script>
function renumber(){
  const blocks = document.querySelectorAll('#blocks .block');
  blocks.forEach((b, idx)=>{
    b.dataset.idx = idx;
    // renumber name attributes
    b.querySelectorAll('input,select,textarea').forEach(el=>{
      el.name = el.name.replace(/blocks\[\d+\]/, 'blocks['+idx+']');
    });
    b.querySelector('.block-head strong').textContent = 'Block #'+(idx+1);
  });
}
function addBlock(){
  const i = document.querySelectorAll('#blocks .block').length;
  const html = `<?=preg_replace('~\s+~',' ',str_replace(["\n","'"],['','\\\''],block_editor(999,'html',['html'=>''])) )?>`.replace(/\[999\]/g,'['+i+']').replace(/data-idx="999"/,'data-idx="'+i+'"').replace('Block #1000','Block #'+(i+1));
  document.getElementById('blocks').insertAdjacentHTML('beforeend', html);
  renumber();
}
function delBlock(btn){
  const b = btn.closest('.block'); b.parentNode.removeChild(b); renumber();
}
function moveUp(btn){
  const b = btn.closest('.block'); const prev = b.previousElementSibling;
  if (prev) { b.parentNode.insertBefore(b, prev); renumber(); }
}
function moveDown(btn){
  const b = btn.closest('.block'); const next = b.nextElementSibling;
  if (next) { b.parentNode.insertBefore(next, b); renumber(); }
}
function dupBlock(btn){
  const b = btn.closest('.block'); const clone = b.cloneNode(true);
  document.getElementById('blocks').insertBefore(clone, b.nextElementSibling);
  renumber();
}
function switchType(sel){
  const block = sel.closest('.block');
  block.querySelectorAll('.tf').forEach(x=>x.style.display='none');
  const t = sel.value;
  const on = block.querySelector('.tf-'+t);
  if (on) on.style.display='';
}
</script>
