<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin']);
require_once __DIR__.'/../core/db.php'; require_once __DIR__.'/../core/helpers.php';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $cat = (int)$_POST['category_id'];
  $pos = (int)$_POST['position'];
  // Upsert: unique on position OR category_id
  $exists = DB::run("SELECT id FROM site_menus WHERE category_id=?",[$cat])->fetchColumn();
  if($exists){
    DB::run("UPDATE site_menus SET position=? WHERE id=?",[$pos,(int)$exists]);
  }else{
    // If position occupied, swap them
    $other = DB::run("SELECT id FROM site_menus WHERE position=?",[$pos])->fetchColumn();
    if($other){ DB::run("UPDATE site_menus SET position=position+1000 WHERE id=?",[(int)$other]); } // temporary move
    DB::run("INSERT INTO site_menus(category_id,position) VALUES (?,?)",[$cat,$pos]);
    if($other){ DB::run("UPDATE site_menus SET position=? WHERE id=?",[$pos+1,(int)$other]); }
  }
  header("Location: menu_setup.php?saved=1"); exit;
}

if(isset($_GET['del'])){
  DB::run("DELETE FROM site_menus WHERE id=?",[(int)$_GET['del']]);
  header("Location: menu_setup.php"); exit;
}

$cats = DB::run("SELECT id,name_bn FROM categories ORDER BY name_bn")->fetchAll();
$menus= DB::run("SELECT sm.*, c.name_bn AS name FROM site_menus sm LEFT JOIN categories c ON c.id=sm.category_id ORDER BY position")->fetchAll();

include __DIR__.'/partials/header.php';
include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Menu Setup</h2>
  <?php if(isset($_GET['saved'])): ?><div class="alert success">Saved.</div><?php endif;?>
  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Select Menu (category)</label>
        <select name="category_id" required>
          <option value="">— Category —</option>
          <?php foreach($cats as $c): ?><option value="<?= (int)$c['id'] ?>"><?= e($c['name_bn']) ?></option><?php endforeach;?>
        </select>
        <label>Position</label>
        <input type="number" name="position" required placeholder="1,2,3,...">
        <button class="btn">Save</button>
      </form>
    </div>
    <div class="panel">
      <h3>All menus</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Name</th><th>Position</th><th>Manage</th></tr></thead>
        <tbody><?php $i=1; foreach($menus as $m): ?>
          <tr>
            <td><?= $i++ ?></td><td><?= e($m['name']) ?></td><td><?= (int)$m['position'] ?></td>
            <td><a class="btn-sm" style="background:#f44336" href="menu_setup.php?del=<?= (int)$m['id'] ?>" onclick="return confirm('Delete menu?')">🗑️</a></td>
          </tr>
        <?php endforeach; if(!$menus): ?><tr><td colspan="4">No items.</td></tr><?php endif;?></tbody>
      </table>
    </div>
  </div>
</div>
</main></div>
<?php include __DIR__.'/partials/footer.php';
