<?php
require_once __DIR__ . '/../core/helpers.php';
require_once __DIR__ . '/../core/auth.php';

$err = '';

if (is_post()) {
  if (!csrf_check($_POST['csrf'] ?? '')) {
    $err = 'Invalid CSRF';
  } else {
    $email = trim($_POST['email'] ?? '');
    $pass  = (string)($_POST['password'] ?? '');
    if (login($email, $pass)) {
      // IMPORTANT: do NOT use redirect()/base_url() here (that points to /public)
      header('Location: dashboard.php');
      exit;
    } else {
      $err = 'Wrong email or password';
    }
  }
}
?>
<!doctype html>
<html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin • Sign In</title>
<link rel="stylesheet" href="assets/css/admin.css">
</head><body class="login">
  <form class="login-card" method="post" action="">
    <h1>Vurrer Kagoj</h1>
    <?php if ($err): ?><p class="error"><?= e($err) ?></p><?php endif; ?>
    <label>Email <input type="email" name="email" required></label>
    <label>Password <input type="password" name="password" required></label>
    <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
    <button type="submit">Sign In</button>
  </form>
</body></html>
