<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin']);
require_once __DIR__.'/../core/db.php'; require_once __DIR__.'/../core/helpers.php';

$id = isset($_GET['id'])?(int)$_GET['id']:0;
$row = ['tv_link'=>'','name_bn'=>'','name_en'=>'','code'=>'','population'=>0,'history'=>''];
if($id) $row = DB::run("SELECT * FROM divisions WHERE id=?",[$id])->fetch() ?: $row;

if($_SERVER['REQUEST_METHOD']==='POST'){
  $vals = [
    trim($_POST['tv_link']??''), trim($_POST['name_bn']??''), trim($_POST['name_en']??''),
    trim($_POST['code']??''), (int)($_POST['population']??0), trim($_POST['history']??'')
  ];
  if($id){ DB::run("UPDATE divisions SET tv_link=?,name_bn=?,name_en=?,code=?,population=?,history=? WHERE id=?", array_merge($vals,[$id])); }
  else { DB::run("INSERT INTO divisions(tv_link,name_bn,name_en,code,population,history) VALUES (?,?,?,?,?,?)",$vals); }
  header("Location: division.php".($id?"?id=$id":"")."&saved=1"); exit;
}
$list = DB::run("SELECT * FROM divisions ORDER BY name_bn")->fetchAll();

include __DIR__.'/partials/header.php'; include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Division</h2>
  <?php if(isset($_GET['saved'])): ?><div class="alert success">Saved.</div><?php endif;?>
  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Division TV Link</label><input name="tv_link" value="<?= e($row['tv_link']) ?>">
        <label>Name (BN) *</label><input name="name_bn" required value="<?= e($row['name_bn']) ?>">
        <label>EN Name</label><input name="name_en" value="<?= e($row['name_en']) ?>">
        <label>Code</label><input name="code" value="<?= e($row['code']) ?>">
        <label>Population</label><input type="number" name="population" value="<?= (int)$row['population'] ?>">
        <label>History</label><input name="history" value="<?= e($row['history']) ?>">
        <button class="btn"><?= $id?'Update':'Save' ?></button> <?php if($id): ?><a class="btn" href="division.php">New</a><?php endif;?>
      </form>
    </div>
    <div class="panel">
      <h3>All Divisions</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Name</th><th>EN</th><th>Code</th><th>Population</th><th>TV Link</th><th>Edit</th></tr></thead>
        <tbody><?php $i=1; foreach($list as $r): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= e($r['name_bn']) ?></td><td><?= e($r['name_en']) ?></td><td><?= e($r['code']) ?></td>
            <td><?= (int)$r['population'] ?></td><td><?= e($r['tv_link']) ?></td>
            <td><a class="btn-sm" href="division.php?id=<?= (int)$r['id'] ?>">✏️</a></td>
          </tr>
        <?php endforeach; if(!$list): ?><tr><td colspan="7">No data.</td></tr><?php endif;?></tbody>
      </table>
    </div>
  </div>
</div>
</main></div>
<?php include __DIR__.'/partials/footer.php';
