<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin']);
require_once __DIR__.'/../core/db.php'; require_once __DIR__.'/../core/helpers.php';

$id = isset($_GET['id'])?(int)$_GET['id']:0;
$row = ['name'=>''];
if($id) $row = DB::run("SELECT * FROM designations WHERE id=?",[$id])->fetch() ?: $row;

if($_SERVER['REQUEST_METHOD']==='POST'){
  $name = trim($_POST['name']??'');
  if($id){ DB::run("UPDATE designations SET name=? WHERE id=?",[$name,$id]); }
  else { DB::run("INSERT INTO designations(name) VALUES (?)",[$name]); }
  header("Location: designation.php".($id?"?id=$id":"")."&saved=1"); exit;
}
$list = DB::run("SELECT * FROM designations ORDER BY name")->fetchAll();

include __DIR__.'/partials/header.php'; include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Designation</h2>
  <?php if(isset($_GET['saved'])): ?><div class="alert success">Saved.</div><?php endif;?>
  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Name *</label><input name="name" value="<?= e($row['name']) ?>" required>
        <button class="btn"><?= $id?'Update':'Save' ?></button> <?php if($id): ?><a class="btn" href="designation.php">New</a><?php endif;?>
      </form>
    </div>
    <div class="panel">
      <h3>All Designations</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Name</th><th>Edit</th></tr></thead>
        <tbody><?php $i=1; foreach($list as $r): ?>
          <tr><td><?= $i++ ?></td><td><?= e($r['name']) ?></td><td><a class="btn-sm" href="designation.php?id=<?= (int)$r['id'] ?>">✏️</a></td></tr>
        <?php endforeach; if(!$list): ?><tr><td colspan="3">No data.</td></tr><?php endif;?></tbody>
      </table>
    </div>
  </div>
</div>
</main></div>
<?php include __DIR__.'/partials/footer.php';
