<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin']);
require_once __DIR__.'/../core/db.php'; require_once __DIR__.'/../core/helpers.php';

$id = isset($_GET['id'])?(int)$_GET['id']:0;
$row = ['name'=>'','zone'=>'','population'=>0,'code'=>'','phone_code'=>'','domain_code'=>''];
if($id) $row = DB::run("SELECT * FROM countries WHERE id=?",[$id])->fetch() ?: $row;

if($_SERVER['REQUEST_METHOD']==='POST'){
  $vals = [
    trim($_POST['name']??''),
    trim($_POST['zone']??''),
    (int)($_POST['population']??0),
    trim($_POST['code']??''),
    trim($_POST['phone_code']??''),
    trim($_POST['domain_code']??'')
  ];
  if($id){
    DB::run("UPDATE countries SET name=?,zone=?,population=?,code=?,phone_code=?,domain_code=? WHERE id=?",
      array_merge($vals,[$id]));
  }else{
    DB::run("INSERT INTO countries(name,zone,population,code,phone_code,domain_code) VALUES (?,?,?,?,?,?)",$vals);
    $id = (int)DB::run("SELECT LAST_INSERT_ID()")->fetchColumn();
  }
  header("Location: country.php?id=".$id."&saved=1"); exit;
}

$list = DB::run("SELECT * FROM countries ORDER BY name")->fetchAll();

include __DIR__.'/partials/header.php';
include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Country</h2>
  <?php if(isset($_GET['saved'])): ?><div class="alert success">Saved.</div><?php endif;?>
  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Name *</label><input name="name" value="<?= e($row['name']) ?>" required>
        <label>Zone</label><input name="zone" value="<?= e($row['zone']) ?>">
        <label>Population</label><input type="number" name="population" value="<?= (int)$row['population'] ?>">
        <label>Code</label><input name="code" value="<?= e($row['code']) ?>">
        <label>Phone Code</label><input name="phone_code" value="<?= e($row['phone_code']) ?>">
        <label>Domain Code</label><input name="domain_code" value="<?= e($row['domain_code']) ?>">
        <button class="btn"><?= $id?'Update':'Save' ?></button> <?php if($id): ?><a class="btn" href="country.php">New</a><?php endif; ?>
      </form>
    </div>
    <div class="panel">
      <h3>All Countries</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Name</th><th>Zone</th><th>Population</th><th>Code</th><th>Phone</th><th>Domain</th><th>Edit</th></tr></thead>
        <tbody>
          <?php $i=1; foreach($list as $r): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= e($r['name']) ?></td>
              <td><?= e($r['zone']) ?></td>
              <td><?= (int)$r['population'] ?></td>
              <td><?= e($r['code']) ?></td>
              <td><?= e($r['phone_code']) ?></td>
              <td><?= e($r['domain_code']) ?></td>
              <td><a class="btn-sm" href="country.php?id=<?= (int)$r['id'] ?>">✏️</a></td>
            </tr>
          <?php endforeach; if(!$list): ?><tr><td colspan="8">No data.</td></tr><?php endif;?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</main></div>
<?php include __DIR__.'/partials/footer.php';
