<?php
require_once __DIR__.'/../core/auth.php'; require_login(); require_role(['admin']);
require_once __DIR__.'/../core/db.php'; require_once __DIR__.'/../core/helpers.php';

$id = isset($_GET['id'])?(int)$_GET['id']:0;
$row = ['division_id'=>'','name_bn'=>'','name_en'=>'','code'=>'','population'=>0,'history'=>''];
if($id) $row = DB::run("SELECT * FROM cities WHERE id=?",[$id])->fetch() ?: $row;

if($_SERVER['REQUEST_METHOD']==='POST'){
  $div = (int)$_POST['division_id'];
  $nbn = trim($_POST['name_bn']??'');
  $nen = trim($_POST['name_en']??'');
  $code= trim($_POST['code']??'');
  $pop = (int)($_POST['population']??0);
  $his = trim($_POST['history']??'');
  if($id){
    DB::run("UPDATE cities SET division_id=?,name_bn=?,name_en=?,code=?,population=?,history=? WHERE id=?",
      [$div,$nbn,$nen,$code,$pop,$his,$id]);
  }else{
    DB::run("INSERT INTO cities(division_id,name_bn,name_en,code,population,history) VALUES (?,?,?,?,?,?)",
      [$div,$nbn,$nen,$code,$pop,$his]);
    $id = (int)DB::run("SELECT LAST_INSERT_ID()")->fetchColumn();
  }
  header("Location: city.php?id=".$id."&saved=1"); exit;
}

$divs = DB::run("SELECT id,name_bn FROM divisions ORDER BY name_bn")->fetchAll();
$list = DB::run("SELECT c.*, d.name_bn AS div_name FROM cities c LEFT JOIN divisions d ON d.id=c.division_id ORDER BY d.name_bn, c.name_bn")->fetchAll();

include __DIR__.'/partials/header.php';
include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>City</h2>
  <?php if(isset($_GET['saved'])): ?><div class="alert success">Saved.</div><?php endif; ?>
  <div class="grid-2">
    <div class="panel">
      <form method="post">
        <label>Select Division</label>
        <select name="division_id" required>
          <option value="">— Select Division —</option>
          <?php foreach($divs as $d): ?>
            <option value="<?= (int)$d['id'] ?>" <?= (int)$row['division_id']===(int)$d['id']?'selected':'' ?>><?= e($d['name_bn']) ?></option>
          <?php endforeach; ?>
        </select>

        <label>Name (BN) *</label>
        <input name="name_bn" required value="<?= e($row['name_bn']) ?>">

        <label>EN Name</label>
        <input name="name_en" value="<?= e($row['name_en']) ?>">

        <label>Code</label>
        <input name="code" value="<?= e($row['code']) ?>">

        <label>Population</label>
        <input type="number" name="population" value="<?= (int)$row['population'] ?>">

        <label>History</label>
        <input name="history" value="<?= e($row['history']) ?>">

        <button class="btn"><?= $id?'Update':'Save' ?></button>
        <?php if($id): ?><a class="btn" href="city.php">New</a><?php endif; ?>
      </form>
    </div>

    <div class="panel">
      <h3>All Cities</h3>
      <table class="table">
        <thead><tr><th>SL</th><th>Division</th><th>Name</th><th>EN</th><th>Code</th><th>Population</th><th>Edit</th></tr></thead>
        <tbody>
          <?php $i=1; foreach($list as $r): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= e($r['div_name']) ?></td>
              <td><?= e($r['name_bn']) ?></td>
              <td><?= e($r['name_en']) ?></td>
              <td><?= e($r['code']) ?></td>
              <td><?= (int)$r['population'] ?></td>
              <td><a class="btn-sm" href="city.php?id=<?= (int)$r['id'] ?>">✏️</a></td>
            </tr>
          <?php endforeach; if(!$list): ?><tr><td colspan="7">No data.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</main></div>
<?php include __DIR__.'/partials/footer.php';
