<?php
// admin/categories.php
require_once __DIR__ . '/../core/auth.php';  require_login();  require_role(['admin']);
require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

// --- tiny fallback: slugify if helpers doesn't have one ---
if (!function_exists('slugify')) {
  function slugify(string $text): string {
    $text = trim($text);
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = trim($text, '-');
    return mb_strtolower($text, 'UTF-8');
  }
}

/* ----------------- actions ----------------- */
if (isset($_GET['del'])) {
  $del = (int)$_GET['del'];
  // optional: prevent delete if has children
  DB::run("DELETE FROM categories WHERE id=?", [$del]);
  header("Location: categories.php?deleted=1"); exit;
}

$id  = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$cat = ['parent_id'=>null,'name_bn'=>'','slug'=>'','is_active'=>1];

if ($id) {
  $row = DB::run("SELECT id,parent_id,name_bn,slug,is_active FROM categories WHERE id=?",[$id])->fetch();
  if ($row) { $cat = $row; } else { $id = 0; }
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $parent_id = ($_POST['parent_id'] !== '') ? (int)$_POST['parent_id'] : null;
  $name_bn   = trim($_POST['name_bn'] ?? '');
  $slug      = trim($_POST['slug'] ?? '');
  $is_active = isset($_POST['is_active']) ? 1 : 0;

  if ($slug === '' && $name_bn !== '') $slug = slugify($name_bn);

  if ($id) {
    DB::run(
      "UPDATE categories SET parent_id=?, name_bn=?, slug=?, is_active=? WHERE id=?",
      [$parent_id, $name_bn, $slug ?: null, $is_active, $id]
    );
  } else {
    DB::run(
      "INSERT INTO categories (parent_id, name_bn, slug, is_active) VALUES (?,?,?,?)",
      [$parent_id, $name_bn, $slug ?: null, $is_active]
    );
    $id = (int)DB::run("SELECT LAST_INSERT_ID()")->fetchColumn();
  }
  header("Location: categories.php?id={$id}&saved=1"); exit;
}

/* ----------------- data for UI ----------------- */
$parents = DB::run("SELECT id,name_bn FROM categories ORDER BY name_bn")->fetchAll();

$rows = DB::run("
  SELECT c.id, c.parent_id, c.name_bn, c.slug, c.is_active,
         p.name_bn AS parent,
         COALESCE(pc.cnt,0) AS total_posts
    FROM categories c
    LEFT JOIN categories p ON p.id = c.parent_id
    LEFT JOIN (
      SELECT category_id, COUNT(*) cnt
        FROM posts
       GROUP BY category_id
    ) pc ON pc.category_id = c.id
   ORDER BY c.name_bn
")->fetchAll();

/* ----------------- layout ----------------- */
include __DIR__.'/partials/header.php';
include __DIR__.'/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Category</h2>
  <?php if (isset($_GET['saved'])): ?>
    <div class="alert success">Saved.</div>
  <?php elseif (isset($_GET['deleted'])): ?>
    <div class="alert success">Deleted.</div>
  <?php endif; ?>

  <div class="grid-2">
    <!-- FORM -->
    <div class="panel">
      <form method="post" autocomplete="off">
        <label>Select Parent Category</label>
        <select name="parent_id">
          <option value="">— None —</option>
          <?php foreach($parents as $p): ?>
            <option value="<?= (int)$p['id'] ?>" <?= ((int)$cat['parent_id']===(int)$p['id'])?'selected':'' ?>>
              <?= e($p['name_bn']) ?>
            </option>
          <?php endforeach; ?>
        </select>

        <label>BN Name *</label>
        <input name="name_bn" required value="<?= e($cat['name_bn']) ?>">

        <label>Slug (optional)</label>
        <input name="slug" value="<?= e($cat['slug']) ?>">

        <label style="display:flex;gap:10px;align-items:center;margin-top:6px">
          <input type="checkbox" name="is_active" <?= $cat['is_active'] ? 'checked' : '' ?>> Active
        </label>

        <div style="display:flex;gap:8px;margin-top:12px">
          <button class="btn"><?= $id ? 'Update' : 'Save' ?></button>
          <?php if ($id): ?><a class="btn" href="categories.php">New</a><?php endif; ?>
        </div>
      </form>
    </div>

    <!-- LIST -->
    <div class="panel">
      <h3>All Categories</h3>
      <table class="table">
        <thead>
          <tr>
            <th>SL</th>
            <th>Parent Category</th>
            <th>Name</th>
            <th>Slug</th>
            <th>Active</th>
            <th>Total Posts</th>
            <th>Manage</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($rows): $i=1; foreach ($rows as $r): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= e($r['parent'] ?: '—') ?></td>
            <td><?= e($r['name_bn']) ?></td>
            <td><?= e($r['slug'] ?: '') ?></td>
            <td><?= $r['is_active'] ? 'Yes' : 'No' ?></td>
            <td><?= (int)$r['total_posts'] ?></td>
            <td>
              <a class="btn-sm" href="categories.php?id=<?= (int)$r['id'] ?>">Edit</a>
              <a class="btn-sm" style="background:#f44336"
                 href="categories.php?del=<?= (int)$r['id'] ?>"
                 onclick="return confirm('Delete this category?')">Del</a>
            </td>
          </tr>
        <?php endforeach; else: ?>
          <tr><td colspan="7">No data.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include __DIR__.'/partials/footer.php'; ?>
