<?php
// admin/ad_clients.php
require_once __DIR__ . '/../core/auth.php';
require_login();
require_role(['admin']);  // add 'editor' if you like

require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

function col_exists($t,$c){
  return (int)DB::run(
    "SELECT COUNT(*) FROM information_schema.COLUMNS
     WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME=? AND COLUMN_NAME=?",
    [$t,$c]
  )->fetchColumn() > 0;
}

/* ---------- delete ---------- */
if (($_GET['action'] ?? '') === 'delete' && isset($_GET['id'])) {
  DB::run("DELETE FROM ad_clients WHERE id=?", [(int)$_GET['id']]);
  header("Location: ad_clients.php?msg=deleted");
  exit;
}

/* ---------- dynamic SELECT based on existing columns ---------- */
$cols = ['id','name'];
$optional = ['contact_person','phone','email','website','status','logo_path','notes'];
foreach ($optional as $c) if (col_exists('ad_clients',$c)) $cols[] = $c;

$select = implode(',', array_map(fn($c)=>$c, $cols));

$q = trim($_GET['q'] ?? '');
$params = [];
$sql = "SELECT $select FROM ad_clients WHERE 1";
if ($q !== '') {
  $searchable = array_values(array_intersect(['name','contact_person','phone','email','website','notes'],$cols));
  if ($searchable) {
    $like = [];
    foreach ($searchable as $sc) $like[] = "$sc LIKE :q";
    $sql .= " AND (".implode(' OR ', $like).")";
    $params[':q'] = "%$q%";
  }
}
$sql .= " ORDER BY id DESC LIMIT 200";
$rows = DB::run($sql, $params)->fetchAll();

include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="admin-container">
  <h2>Ad Clients</h2>

  <?php if (isset($_GET['msg']) && $_GET['msg']==='deleted'): ?>
    <div class="alert success">Client deleted.</div>
  <?php endif; ?>

  <div style="display:flex;gap:8px;align-items:center;margin-bottom:12px">
    <form method="get" class="form-inline">
      <input type="text" name="q" value="<?= e($q) ?>" placeholder="Search name, email, phone…">
      <button class="btn">Search</button>
    </form>
    <a class="btn" href="ad_client_edit.php">+ New Client</a>
  </div>

  <table class="table">
    <thead>
      <tr>
        <th>#</th>
        <th>Name</th>
        <?php if (in_array('contact_person',$cols)): ?><th>Contact</th><?php endif; ?>
        <?php if (in_array('phone',$cols)): ?><th>Phone</th><?php endif; ?>
        <?php if (in_array('email',$cols)): ?><th>Email</th><?php endif; ?>
        <?php if (in_array('status',$cols)): ?><th>Status</th><?php endif; ?>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php $i=1; foreach ($rows as $r): ?>
        <tr>
          <td><?= $i++ ?></td>
          <td><?= e($r['name'] ?? '') ?></td>
          <?php if (in_array('contact_person',$cols)): ?><td><?= e($r['contact_person'] ?? '') ?></td><?php endif; ?>
          <?php if (in_array('phone',$cols)): ?><td><?= e($r['phone'] ?? '') ?></td><?php endif; ?>
          <?php if (in_array('email',$cols)): ?><td><?= e($r['email'] ?? '') ?></td><?php endif; ?>
          <?php if (in_array('status',$cols)): ?><td><?= e($r['status'] ?? '') ?></td><?php endif; ?>
          <td>
            <a class="btn-sm" href="ad_client_edit.php?id=<?= (int)$r['id'] ?>">Edit</a>
            <a class="btn-sm" style="background:#f44336"
               href="ad_clients.php?action=delete&id=<?= (int)$r['id'] ?>"
               onclick="return confirm('Delete this client?')">Delete</a>
          </td>
        </tr>
      <?php endforeach; if (!$rows): ?>
        <tr><td colspan="7">No data.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
