<?php
// admin/ad_client_edit.php
require_once __DIR__ . '/../core/auth.php';
require_login();
require_role(['admin']); // add 'editor' if you like

require_once __DIR__ . '/../core/db.php';
require_once __DIR__ . '/../core/helpers.php';

function col_exists($t,$c){
  return (int)DB::run(
    "SELECT COUNT(*) FROM information_schema.COLUMNS
     WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME=? AND COLUMN_NAME=?",
    [$t,$c]
  )->fetchColumn() > 0;
}

$has = [
  'contact_person' => col_exists('ad_clients','contact_person'),
  'phone'          => col_exists('ad_clients','phone'),
  'email'          => col_exists('ad_clients','email'),
  'website'        => col_exists('ad_clients','website'),
  'status'         => col_exists('ad_clients','status'),
  'logo_path'      => col_exists('ad_clients','logo_path'),
  'notes'          => col_exists('ad_clients','notes'),
  'created_at'     => col_exists('ad_clients','created_at'),
  'updated_at'     => col_exists('ad_clients','updated_at'),
];

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

/* ---------- fetch row ---------- */
$base = ['name'=>''];
if ($has['contact_person']) $base['contact_person'] = '';
if ($has['phone'])          $base['phone']          = '';
if ($has['email'])          $base['email']          = '';
if ($has['website'])        $base['website']        = '';
if ($has['status'])         $base['status']         = 'active';
if ($has['logo_path'])      $base['logo_path']      = '';
if ($has['notes'])          $base['notes']          = '';

$row = $base;
if ($id) {
  $selCols = array_keys($base);
  array_unshift($selCols,'id');
  $select = implode(',', $selCols);
  $row = DB::run("SELECT $select FROM ad_clients WHERE id=?",[$id])->fetch() ?: $base;
}

/* ---------- handle save ---------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  if ($name === '') { $name = '(unnamed)'; }

  $data = ['name'=>$name];
  if ($has['contact_person']) $data['contact_person'] = trim($_POST['contact_person'] ?? '');
  if ($has['phone'])          $data['phone']          = trim($_POST['phone'] ?? '');
  if ($has['email'])          $data['email']          = trim($_POST['email'] ?? '');
  if ($has['website'])        $data['website']        = trim($_POST['website'] ?? '');
  if ($has['status'])         $data['status']         = in_array(($_POST['status'] ?? 'active'),['active','inactive']) ? $_POST['status'] : 'active';
  if ($has['notes'])          $data['notes']          = trim($_POST['notes'] ?? '');

  // upload logo if column exists
  if ($has['logo_path'] && !empty($_FILES['logo']['tmp_name'])) {
    @mkdir(__DIR__.'/../uploads/clients', 0777, true);
    $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
    if (in_array($ext, ['png','jpg','jpeg','webp','gif'])) {
      $fname = 'client_'.time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
      $dest  = __DIR__ . '/../uploads/clients/' . $fname;
      if (move_uploaded_file($_FILES['logo']['tmp_name'], $dest)) {
        $data['logo_path'] = 'uploads/clients/'.$fname; // relative path from /admin
      }
    }
  }

  if ($id) {
    // UPDATE
    $set = [];
    $vals = [];
    foreach ($data as $c=>$v){ $set[] = "$c=?"; $vals[] = $v; }
    if ($has['updated_at']) { $set[] = "updated_at=NOW()"; }
    $vals[] = $id;
    DB::run("UPDATE ad_clients SET ".implode(',',$set)." WHERE id=?", $vals);
  } else {
    // INSERT
    if ($has['created_at']) $data['created_at'] = date('Y-m-d H:i:s');
    if ($has['updated_at']) $data['updated_at'] = date('Y-m-d H:i:s');

    $cols = array_keys($data);
    $qs   = implode(',', array_fill(0,count($cols),'?'));
    DB::run("INSERT INTO ad_clients (".implode(',',$cols).") VALUES ($qs)", array_values($data));
    $id = (int)DB::run("SELECT LAST_INSERT_ID()")->fetchColumn();
  }
  header("Location: ad_client_edit.php?id=".$id."&saved=1");
  exit;
}

include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/sidebar.php';
?>
<div class="admin-container">
  <h2><?= $id ? 'Edit Client' : 'New Client' ?></h2>

  <?php if (isset($_GET['saved'])): ?>
    <div class="alert success">Saved.</div>
  <?php endif; ?>

  <form method="post" enctype="multipart/form-data" class="form">
    <div class="grid-2">
      <div class="panel">
        <label>Client Name *</label>
        <input type="text" name="name" value="<?= e($row['name']) ?>" required>

        <?php if ($has['contact_person']): ?>
          <label>Contact Person</label>
          <input type="text" name="contact_person" value="<?= e($row['contact_person']) ?>">
        <?php endif; ?>

        <div class="grid-2">
          <?php if ($has['phone']): ?>
            <div>
              <label>Phone</label>
              <input type="text" name="phone" value="<?= e($row['phone']) ?>">
            </div>
          <?php endif; ?>
          <?php if ($has['email']): ?>
            <div>
              <label>Email</label>
              <input type="email" name="email" value="<?= e($row['email']) ?>">
            </div>
          <?php endif; ?>
        </div>

        <?php if ($has['website']): ?>
          <label>Website</label>
          <input type="text" name="website" value="<?= e($row['website']) ?>" placeholder="https://">
        <?php endif; ?>

        <?php if ($has['status']): ?>
          <label>Status</label>
          <select name="status">
            <option value="active"   <?= ($row['status']??'active')==='active'?'selected':'' ?>>Active</option>
            <option value="inactive" <?= ($row['status']??'active')==='inactive'?'selected':'' ?>>Inactive</option>
          </select>
        <?php endif; ?>
      </div>

      <div class="panel">
        <h3>Logo & Notes</h3>
        <?php if ($has['logo_path']): ?>
          <?php if (!empty($row['logo_path'])): ?>
            <div style="margin-bottom:8px">
              <img src="<?= e('../'.$row['logo_path']) ?>" alt="logo" style="max-height:60px">
            </div>
          <?php endif; ?>
          <label>Upload new logo</label>
          <input type="file" name="logo" accept=".png,.jpg,.jpeg,.webp,.gif">
        <?php endif; ?>

        <?php if ($has['notes']): ?>
          <label>Notes</label>
          <textarea name="notes" rows="6"><?= e($row['notes']) ?></textarea>
        <?php endif; ?>

        <div style="margin-top:12px">
          <button class="btn"><?= $id? 'Update' : 'Create' ?></button>
          <a class="btn" href="ad_clients.php">Back</a>
        </div>
      </div>
    </div>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
